@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentSlotValueElicitationPromptArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property maxAttempts The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
 * @property messages
 * @property responseCard
 */
public data class IntentSlotValueElicitationPromptArgs(
    public val maxAttempts: Output<Int>,
    public val messages: Output<List<IntentSlotValueElicitationPromptMessageArgs>>,
    public val responseCard: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentSlotValueElicitationPromptArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentSlotValueElicitationPromptArgs =
        com.pulumi.aws.lex.inputs.IntentSlotValueElicitationPromptArgs.builder()
            .maxAttempts(maxAttempts.applyValue({ args0 -> args0 }))
            .messages(
                messages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseCard(responseCard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntentSlotValueElicitationPromptArgs].
 */
@PulumiTagMarker
public class IntentSlotValueElicitationPromptArgsBuilder internal constructor() {
    private var maxAttempts: Output<Int>? = null

    private var messages: Output<List<IntentSlotValueElicitationPromptMessageArgs>>? = null

    private var responseCard: Output<String>? = null

    /**
     * @param value The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
     */
    @JvmName("abvhdsddevkutqod")
    public suspend fun maxAttempts(`value`: Output<Int>) {
        this.maxAttempts = value
    }

    /**
     * @param value
     */
    @JvmName("wnhdmggckprsnrot")
    public suspend fun messages(`value`: Output<List<IntentSlotValueElicitationPromptMessageArgs>>) {
        this.messages = value
    }

    @JvmName("vsfrqhynbmbjehug")
    public suspend fun messages(vararg values: Output<IntentSlotValueElicitationPromptMessageArgs>) {
        this.messages = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ghajlfsljvcgtlim")
    public suspend fun messages(values: List<Output<IntentSlotValueElicitationPromptMessageArgs>>) {
        this.messages = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("elxbhrlrpshjydbv")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
     */
    @JvmName("rrntsahkpcsojxiv")
    public suspend fun maxAttempts(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxAttempts = mapped
    }

    /**
     * @param value
     */
    @JvmName("btxheeciadfusplx")
    public suspend fun messages(`value`: List<IntentSlotValueElicitationPromptMessageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("msstgvacgxtwdwrh")
    public suspend fun messages(argument: List<suspend IntentSlotValueElicitationPromptMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IntentSlotValueElicitationPromptMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rnourhgmqdtvsryb")
    public suspend fun messages(vararg argument: suspend IntentSlotValueElicitationPromptMessageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IntentSlotValueElicitationPromptMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("iwebnqhdrjpmxdbb")
    public suspend fun messages(argument: suspend IntentSlotValueElicitationPromptMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IntentSlotValueElicitationPromptMessageArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param values
     */
    @JvmName("rtuixddeiunfhgub")
    public suspend fun messages(vararg values: IntentSlotValueElicitationPromptMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param value
     */
    @JvmName("ysxgnnbqewpqegvj")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    internal fun build(): IntentSlotValueElicitationPromptArgs = IntentSlotValueElicitationPromptArgs(
        maxAttempts = maxAttempts ?: throw PulumiNullFieldException("maxAttempts"),
        messages = messages ?: throw PulumiNullFieldException("messages"),
        responseCard = responseCard,
    )
}
