@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsBotDataPrivacyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property childDirected (Required) -  For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying true or false in the childDirected field.
 */
public data class V2modelsBotDataPrivacyArgs(
    public val childDirected: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsBotDataPrivacyArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsBotDataPrivacyArgs =
        com.pulumi.aws.lex.inputs.V2modelsBotDataPrivacyArgs.builder()
            .childDirected(childDirected.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsBotDataPrivacyArgs].
 */
@PulumiTagMarker
public class V2modelsBotDataPrivacyArgsBuilder internal constructor() {
    private var childDirected: Output<Boolean>? = null

    /**
     * @param value (Required) -  For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying true or false in the childDirected field.
     */
    @JvmName("minrqvgjexxakatp")
    public suspend fun childDirected(`value`: Output<Boolean>) {
        this.childDirected = value
    }

    /**
     * @param value (Required) -  For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying true or false in the childDirected field.
     */
    @JvmName("wprfqicxfwforqys")
    public suspend fun childDirected(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.childDirected = mapped
    }

    internal fun build(): V2modelsBotDataPrivacyArgs = V2modelsBotDataPrivacyArgs(
        childDirected = childDirected ?: throw PulumiNullFieldException("childDirected"),
    )
}
