@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsBotLocaleVoiceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property engine Indicates the type of Amazon Polly voice that Amazon Lex should use for voice interaction with the user. Valid values are `standard` and `neural`. If not specified, the default is `standard`.
 * @property voiceId Identifier of the Amazon Polly voice to use.
 */
public data class V2modelsBotLocaleVoiceSettingsArgs(
    public val engine: Output<String>? = null,
    public val voiceId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsBotLocaleVoiceSettingsArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsBotLocaleVoiceSettingsArgs =
        com.pulumi.aws.lex.inputs.V2modelsBotLocaleVoiceSettingsArgs.builder()
            .engine(engine?.applyValue({ args0 -> args0 }))
            .voiceId(voiceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsBotLocaleVoiceSettingsArgs].
 */
@PulumiTagMarker
public class V2modelsBotLocaleVoiceSettingsArgsBuilder internal constructor() {
    private var engine: Output<String>? = null

    private var voiceId: Output<String>? = null

    /**
     * @param value Indicates the type of Amazon Polly voice that Amazon Lex should use for voice interaction with the user. Valid values are `standard` and `neural`. If not specified, the default is `standard`.
     */
    @JvmName("dpndddkfcuxdaspa")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value Identifier of the Amazon Polly voice to use.
     */
    @JvmName("wdqkoqafrrukajho")
    public suspend fun voiceId(`value`: Output<String>) {
        this.voiceId = value
    }

    /**
     * @param value Indicates the type of Amazon Polly voice that Amazon Lex should use for voice interaction with the user. Valid values are `standard` and `neural`. If not specified, the default is `standard`.
     */
    @JvmName("djivwcvcneqrwpmm")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value Identifier of the Amazon Polly voice to use.
     */
    @JvmName("ewirehdhafteueou")
    public suspend fun voiceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.voiceId = mapped
    }

    internal fun build(): V2modelsBotLocaleVoiceSettingsArgs = V2modelsBotLocaleVoiceSettingsArgs(
        engine = engine,
        voiceId = voiceId ?: throw PulumiNullFieldException("voiceId"),
    )
}
