@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsBotVersionLocaleSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property sourceBotVersion
 */
public data class V2modelsBotVersionLocaleSpecificationArgs(
    public val sourceBotVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsBotVersionLocaleSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsBotVersionLocaleSpecificationArgs =
        com.pulumi.aws.lex.inputs.V2modelsBotVersionLocaleSpecificationArgs.builder()
            .sourceBotVersion(sourceBotVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsBotVersionLocaleSpecificationArgs].
 */
@PulumiTagMarker
public class V2modelsBotVersionLocaleSpecificationArgsBuilder internal constructor() {
    private var sourceBotVersion: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("grpxuqxsqorqcdlu")
    public suspend fun sourceBotVersion(`value`: Output<String>) {
        this.sourceBotVersion = value
    }

    /**
     * @param value
     */
    @JvmName("rdgvqgviwuvhhfbu")
    public suspend fun sourceBotVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceBotVersion = mapped
    }

    internal fun build(): V2modelsBotVersionLocaleSpecificationArgs =
        V2modelsBotVersionLocaleSpecificationArgs(
            sourceBotVersion = sourceBotVersion ?: throw PulumiNullFieldException("sourceBotVersion"),
        )
}
