@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property active Whether an intent's closing response is used. When this field is false, the closing response isn't sent to the user. If the active field isn't specified, the default is true.
 * @property closingResponse Configuration block for response that Amazon Lex sends to the user when the intent is complete. See `closing_response`.
 * @property conditional Configuration block for list of conditional branches associated with the intent's closing response. These branches are executed when the `next_step` attribute is set to `EvalutateConditional`. See `conditional`.
 * @property nextStep Next step that the bot executes after playing the intent's closing response. See `next_step`.
 */
public data class V2modelsIntentClosingSettingArgs(
    public val active: Output<Boolean>? = null,
    public val closingResponse: Output<V2modelsIntentClosingSettingClosingResponseArgs>? = null,
    public val conditional: Output<V2modelsIntentClosingSettingConditionalArgs>? = null,
    public val nextStep: Output<V2modelsIntentClosingSettingNextStepArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingArgs.builder()
            .active(active?.applyValue({ args0 -> args0 }))
            .closingResponse(closingResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .conditional(conditional?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nextStep(nextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentClosingSettingArgs].
 */
@PulumiTagMarker
public class V2modelsIntentClosingSettingArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var closingResponse: Output<V2modelsIntentClosingSettingClosingResponseArgs>? = null

    private var conditional: Output<V2modelsIntentClosingSettingConditionalArgs>? = null

    private var nextStep: Output<V2modelsIntentClosingSettingNextStepArgs>? = null

    /**
     * @param value Whether an intent's closing response is used. When this field is false, the closing response isn't sent to the user. If the active field isn't specified, the default is true.
     */
    @JvmName("ojraaemwfxxpmwqc")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Configuration block for response that Amazon Lex sends to the user when the intent is complete. See `closing_response`.
     */
    @JvmName("alwpqvqbftcitgkk")
    public suspend fun closingResponse(`value`: Output<V2modelsIntentClosingSettingClosingResponseArgs>) {
        this.closingResponse = value
    }

    /**
     * @param value Configuration block for list of conditional branches associated with the intent's closing response. These branches are executed when the `next_step` attribute is set to `EvalutateConditional`. See `conditional`.
     */
    @JvmName("wwqhybupgtpvffws")
    public suspend fun conditional(`value`: Output<V2modelsIntentClosingSettingConditionalArgs>) {
        this.conditional = value
    }

    /**
     * @param value Next step that the bot executes after playing the intent's closing response. See `next_step`.
     */
    @JvmName("fctfplwrhjmlkhir")
    public suspend fun nextStep(`value`: Output<V2modelsIntentClosingSettingNextStepArgs>) {
        this.nextStep = value
    }

    /**
     * @param value Whether an intent's closing response is used. When this field is false, the closing response isn't sent to the user. If the active field isn't specified, the default is true.
     */
    @JvmName("onwoedagxtcffiak")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Configuration block for response that Amazon Lex sends to the user when the intent is complete. See `closing_response`.
     */
    @JvmName("oslwwglbhclbhwau")
    public suspend fun closingResponse(`value`: V2modelsIntentClosingSettingClosingResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.closingResponse = mapped
    }

    /**
     * @param argument Configuration block for response that Amazon Lex sends to the user when the intent is complete. See `closing_response`.
     */
    @JvmName("urtoivskffwjhyap")
    public suspend fun closingResponse(argument: suspend V2modelsIntentClosingSettingClosingResponseArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentClosingSettingClosingResponseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.closingResponse = mapped
    }

    /**
     * @param value Configuration block for list of conditional branches associated with the intent's closing response. These branches are executed when the `next_step` attribute is set to `EvalutateConditional`. See `conditional`.
     */
    @JvmName("hrhwtjqqcvymwauh")
    public suspend fun conditional(`value`: V2modelsIntentClosingSettingConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditional = mapped
    }

    /**
     * @param argument Configuration block for list of conditional branches associated with the intent's closing response. These branches are executed when the `next_step` attribute is set to `EvalutateConditional`. See `conditional`.
     */
    @JvmName("nblcwdtehwwlpfos")
    public suspend fun conditional(argument: suspend V2modelsIntentClosingSettingConditionalArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentClosingSettingConditionalArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.conditional = mapped
    }

    /**
     * @param value Next step that the bot executes after playing the intent's closing response. See `next_step`.
     */
    @JvmName("vnhsqhuuwqqaygnh")
    public suspend fun nextStep(`value`: V2modelsIntentClosingSettingNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextStep = mapped
    }

    /**
     * @param argument Next step that the bot executes after playing the intent's closing response. See `next_step`.
     */
    @JvmName("klghaufkaamyvntd")
    public suspend fun nextStep(argument: suspend V2modelsIntentClosingSettingNextStepArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentClosingSettingNextStepArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.nextStep = mapped
    }

    internal fun build(): V2modelsIntentClosingSettingArgs = V2modelsIntentClosingSettingArgs(
        active = active,
        closingResponse = closingResponse,
        conditional = conditional,
        nextStep = nextStep,
    )
}
