@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingClosingResponseMessageGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property message Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
 * @property variations Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
 */
public data class V2modelsIntentClosingSettingClosingResponseMessageGroupArgs(
    public val message: Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgs>,
    public val variations: Output<List<V2modelsIntentClosingSettingClosingResponseMessageGroupVariationArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingClosingResponseMessageGroupArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingClosingResponseMessageGroupArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingClosingResponseMessageGroupArgs.builder()
            .message(message.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .variations(
                variations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentClosingSettingClosingResponseMessageGroupArgs].
 */
@PulumiTagMarker
public class V2modelsIntentClosingSettingClosingResponseMessageGroupArgsBuilder internal constructor() {
    private var message: Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgs>? =
        null

    private var variations:
        Output<List<V2modelsIntentClosingSettingClosingResponseMessageGroupVariationArgs>>? = null

    /**
     * @param value Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("dgpmdbwrkbdmkfdl")
    public suspend fun message(`value`: Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgs>) {
        this.message = value
    }

    /**
     * @param value Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("bmvyelauymjypsti")
    public suspend fun variations(`value`: Output<List<V2modelsIntentClosingSettingClosingResponseMessageGroupVariationArgs>>) {
        this.variations = value
    }

    @JvmName("hxxtudrqimfhpsxc")
    public suspend fun variations(vararg values: Output<V2modelsIntentClosingSettingClosingResponseMessageGroupVariationArgs>) {
        this.variations = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("onfksfsblkdijxoa")
    public suspend fun variations(values: List<Output<V2modelsIntentClosingSettingClosingResponseMessageGroupVariationArgs>>) {
        this.variations = Output.all(values)
    }

    /**
     * @param value Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("momvkjxidjqdogvd")
    public suspend fun message(`value`: V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param argument Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("ybkiehinsafqimsf")
    public suspend fun message(argument: suspend V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.message = mapped
    }

    /**
     * @param value Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("ntnobimgwieushkq")
    public suspend fun variations(`value`: List<V2modelsIntentClosingSettingClosingResponseMessageGroupVariationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("wnccxekryjshjbti")
    public suspend fun variations(argument: List<suspend V2modelsIntentClosingSettingClosingResponseMessageGroupVariationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentClosingSettingClosingResponseMessageGroupVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("hdisfwbqiiwwhjvf")
    public suspend fun variations(vararg argument: suspend V2modelsIntentClosingSettingClosingResponseMessageGroupVariationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentClosingSettingClosingResponseMessageGroupVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("cgjlvaqlnwkuoiqt")
    public suspend fun variations(argument: suspend V2modelsIntentClosingSettingClosingResponseMessageGroupVariationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentClosingSettingClosingResponseMessageGroupVariationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param values Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("ekjrbicdftobydip")
    public suspend fun variations(vararg values: V2modelsIntentClosingSettingClosingResponseMessageGroupVariationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    internal fun build(): V2modelsIntentClosingSettingClosingResponseMessageGroupArgs =
        V2modelsIntentClosingSettingClosingResponseMessageGroupArgs(
            message = message ?: throw PulumiNullFieldException("message"),
            variations = variations,
        )
}
