@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customPayload Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
 * @property imageResponseCard Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
 * @property plainTextMessage Configuration block for a message in plain text format. See `plain_text_message`.
 * @property ssmlMessage Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
 */
public data class V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgs(
    public val customPayload: Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessageCustomPayloadArgs>? =
        null,
    public val imageResponseCard: Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessageImageResponseCardArgs>? =
        null,
    public val plainTextMessage: Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessagePlainTextMessageArgs>? =
        null,
    public val ssmlMessage: Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessageSsmlMessageArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgs.builder()
            .customPayload(customPayload?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageResponseCard(imageResponseCard?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .plainTextMessage(plainTextMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ssmlMessage(ssmlMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgs].
 */
@PulumiTagMarker
public class V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgsBuilder internal constructor() {
    private var customPayload:
        Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessageCustomPayloadArgs>? =
        null

    private var imageResponseCard:
        Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessageImageResponseCardArgs>? =
        null

    private var plainTextMessage:
        Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessagePlainTextMessageArgs>? =
        null

    private var ssmlMessage:
        Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessageSsmlMessageArgs>? = null

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("bsmrfnqecbadnedo")
    public suspend fun customPayload(`value`: Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessageCustomPayloadArgs>) {
        this.customPayload = value
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("bihpywyauirwfolo")
    public suspend fun imageResponseCard(`value`: Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessageImageResponseCardArgs>) {
        this.imageResponseCard = value
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("opdrqlnorqtsdoug")
    public suspend fun plainTextMessage(`value`: Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessagePlainTextMessageArgs>) {
        this.plainTextMessage = value
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("muywflmmiamktwus")
    public suspend fun ssmlMessage(`value`: Output<V2modelsIntentClosingSettingClosingResponseMessageGroupMessageSsmlMessageArgs>) {
        this.ssmlMessage = value
    }

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("btqskpyipjrtsuja")
    public suspend fun customPayload(`value`: V2modelsIntentClosingSettingClosingResponseMessageGroupMessageCustomPayloadArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPayload = mapped
    }

    /**
     * @param argument Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("cokeqvsmpwnfhwuo")
    public suspend fun customPayload(argument: suspend V2modelsIntentClosingSettingClosingResponseMessageGroupMessageCustomPayloadArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentClosingSettingClosingResponseMessageGroupMessageCustomPayloadArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customPayload = mapped
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("qfskoxdttxnvkfal")
    public suspend fun imageResponseCard(`value`: V2modelsIntentClosingSettingClosingResponseMessageGroupMessageImageResponseCardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageResponseCard = mapped
    }

    /**
     * @param argument Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("ddusljtuhydcdjnt")
    public suspend fun imageResponseCard(argument: suspend V2modelsIntentClosingSettingClosingResponseMessageGroupMessageImageResponseCardArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentClosingSettingClosingResponseMessageGroupMessageImageResponseCardArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.imageResponseCard = mapped
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("paklfjcdetqmbfex")
    public suspend fun plainTextMessage(`value`: V2modelsIntentClosingSettingClosingResponseMessageGroupMessagePlainTextMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plainTextMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("nxpqhoxbscfjmnkd")
    public suspend fun plainTextMessage(argument: suspend V2modelsIntentClosingSettingClosingResponseMessageGroupMessagePlainTextMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentClosingSettingClosingResponseMessageGroupMessagePlainTextMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.plainTextMessage = mapped
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("uhrijqbnrlddgjet")
    public suspend fun ssmlMessage(`value`: V2modelsIntentClosingSettingClosingResponseMessageGroupMessageSsmlMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssmlMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("pjcruyidsqeyuuwf")
    public suspend fun ssmlMessage(argument: suspend V2modelsIntentClosingSettingClosingResponseMessageGroupMessageSsmlMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentClosingSettingClosingResponseMessageGroupMessageSsmlMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ssmlMessage = mapped
    }

    internal fun build(): V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgs =
        V2modelsIntentClosingSettingClosingResponseMessageGroupMessageArgs(
            customPayload = customPayload,
            imageResponseCard = imageResponseCard,
            plainTextMessage = plainTextMessage,
            ssmlMessage = ssmlMessage,
        )
}
