@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property buttons Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
 * @property imageUrl URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
 * @property subtitle Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
 * @property title Title to display on the response card. The format of the title is determined by the platform displaying the response card.
 */
public data class
V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardArgs(
    public val buttons: Output<List<V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardButtonArgs>>? =
        null,
    public val imageUrl: Output<String>? = null,
    public val subtitle: Output<String>? = null,
    public val title: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardArgs.builder()
            .buttons(
                buttons?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .imageUrl(imageUrl?.applyValue({ args0 -> args0 }))
            .subtitle(subtitle?.applyValue({ args0 -> args0 }))
            .title(title.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardArgsBuilder
internal constructor() {
    private var buttons:
        Output<List<V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardButtonArgs>>? =
        null

    private var imageUrl: Output<String>? = null

    private var subtitle: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("miewolgprcnkkmuy")
    public suspend fun buttons(`value`: Output<List<V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardButtonArgs>>) {
        this.buttons = value
    }

    @JvmName("tqtlfjuledqdppki")
    public suspend fun buttons(vararg values: Output<V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardButtonArgs>) {
        this.buttons = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("ebxdbpdmgatpfymt")
    public suspend fun buttons(values: List<Output<V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardButtonArgs>>) {
        this.buttons = Output.all(values)
    }

    /**
     * @param value URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
     */
    @JvmName("wbaihrqemetmwnyj")
    public suspend fun imageUrl(`value`: Output<String>) {
        this.imageUrl = value
    }

    /**
     * @param value Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
     */
    @JvmName("xbamagwtlytrsbcq")
    public suspend fun subtitle(`value`: Output<String>) {
        this.subtitle = value
    }

    /**
     * @param value Title to display on the response card. The format of the title is determined by the platform displaying the response card.
     */
    @JvmName("vkqnfjisasfksrhx")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("pqypwtekonwtmkot")
    public suspend fun buttons(`value`: List<V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardButtonArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("heofacaagkrytwkv")
    public suspend fun buttons(argument: List<suspend V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardButtonArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardButtonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("nowjkilapcuctesh")
    public suspend fun buttons(vararg argument: suspend V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardButtonArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardButtonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("wytnsracrgngqdxd")
    public suspend fun buttons(argument: suspend V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardButtonArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardButtonArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param values Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("srvcwbegymtaakko")
    public suspend fun buttons(vararg values: V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardButtonArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.buttons = mapped
    }

    /**
     * @param value URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
     */
    @JvmName("jgwtkjtfpceaswgs")
    public suspend fun imageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageUrl = mapped
    }

    /**
     * @param value Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
     */
    @JvmName("hfslwlhpdynsmyor")
    public suspend fun subtitle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subtitle = mapped
    }

    /**
     * @param value Title to display on the response card. The format of the title is determined by the platform displaying the response card.
     */
    @JvmName("embuuinjvojelyyc")
    public suspend fun title(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardArgs =
        V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCardArgs(
            buttons = buttons,
            imageUrl = imageUrl,
            subtitle = subtitle,
            title = title ?: throw PulumiNullFieldException("title"),
        )
}
