@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property active Whether a conditional branch is active. When active is false, the conditions are not evaluated.
 * @property conditionalBranches Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
 * @property defaultBranch Configuration block for the conditional branch that should be followed when the conditions for other branches are not satisfied. A branch is made up of a condition, a response and a next step. See `default_branch`.
 */
public data class V2modelsIntentClosingSettingConditionalArgs(
    public val active: Output<Boolean>,
    public val conditionalBranches: Output<List<V2modelsIntentClosingSettingConditionalConditionalBranchArgs>>? = null,
    public val defaultBranch: Output<V2modelsIntentClosingSettingConditionalDefaultBranchArgs>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalArgs.builder()
            .active(active.applyValue({ args0 -> args0 }))
            .conditionalBranches(
                conditionalBranches?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .defaultBranch(defaultBranch.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentClosingSettingConditionalArgs].
 */
@PulumiTagMarker
public class V2modelsIntentClosingSettingConditionalArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var conditionalBranches:
        Output<List<V2modelsIntentClosingSettingConditionalConditionalBranchArgs>>? = null

    private var defaultBranch: Output<V2modelsIntentClosingSettingConditionalDefaultBranchArgs>? =
        null

    /**
     * @param value Whether a conditional branch is active. When active is false, the conditions are not evaluated.
     */
    @JvmName("vrgjyigajwbwpays")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("lqgnryesrbtaaxtu")
    public suspend fun conditionalBranches(`value`: Output<List<V2modelsIntentClosingSettingConditionalConditionalBranchArgs>>) {
        this.conditionalBranches = value
    }

    @JvmName("wsvricgskcuktjvm")
    public suspend fun conditionalBranches(vararg values: Output<V2modelsIntentClosingSettingConditionalConditionalBranchArgs>) {
        this.conditionalBranches = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("flrjvprvovttxqgb")
    public suspend fun conditionalBranches(values: List<Output<V2modelsIntentClosingSettingConditionalConditionalBranchArgs>>) {
        this.conditionalBranches = Output.all(values)
    }

    /**
     * @param value Configuration block for the conditional branch that should be followed when the conditions for other branches are not satisfied. A branch is made up of a condition, a response and a next step. See `default_branch`.
     */
    @JvmName("eikajbvvqfssuuou")
    public suspend fun defaultBranch(`value`: Output<V2modelsIntentClosingSettingConditionalDefaultBranchArgs>) {
        this.defaultBranch = value
    }

    /**
     * @param value Whether a conditional branch is active. When active is false, the conditions are not evaluated.
     */
    @JvmName("ivtdyptrbsriigdi")
    public suspend fun active(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("nnxkwxprygrqpvwj")
    public suspend fun conditionalBranches(`value`: List<V2modelsIntentClosingSettingConditionalConditionalBranchArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditionalBranches = mapped
    }

    /**
     * @param argument Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("omaruviystgegxbh")
    public suspend fun conditionalBranches(argument: List<suspend V2modelsIntentClosingSettingConditionalConditionalBranchArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentClosingSettingConditionalConditionalBranchArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditionalBranches = mapped
    }

    /**
     * @param argument Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("fhrudnrtcnyjyfan")
    public suspend fun conditionalBranches(vararg argument: suspend V2modelsIntentClosingSettingConditionalConditionalBranchArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentClosingSettingConditionalConditionalBranchArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditionalBranches = mapped
    }

    /**
     * @param argument Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("ftllupxurhhsokeh")
    public suspend fun conditionalBranches(argument: suspend V2modelsIntentClosingSettingConditionalConditionalBranchArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentClosingSettingConditionalConditionalBranchArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.conditionalBranches = mapped
    }

    /**
     * @param values Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("ymtfcrxxgpvxevxh")
    public suspend fun conditionalBranches(vararg values: V2modelsIntentClosingSettingConditionalConditionalBranchArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditionalBranches = mapped
    }

    /**
     * @param value Configuration block for the conditional branch that should be followed when the conditions for other branches are not satisfied. A branch is made up of a condition, a response and a next step. See `default_branch`.
     */
    @JvmName("achukadmobfujema")
    public suspend fun defaultBranch(`value`: V2modelsIntentClosingSettingConditionalDefaultBranchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultBranch = mapped
    }

    /**
     * @param argument Configuration block for the conditional branch that should be followed when the conditions for other branches are not satisfied. A branch is made up of a condition, a response and a next step. See `default_branch`.
     */
    @JvmName("wnotrercbjoxmcfl")
    public suspend fun defaultBranch(argument: suspend V2modelsIntentClosingSettingConditionalDefaultBranchArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentClosingSettingConditionalDefaultBranchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.defaultBranch = mapped
    }

    internal fun build(): V2modelsIntentClosingSettingConditionalArgs =
        V2modelsIntentClosingSettingConditionalArgs(
            active = active ?: throw PulumiNullFieldException("active"),
            conditionalBranches = conditionalBranches,
            defaultBranch = defaultBranch ?: throw PulumiNullFieldException("defaultBranch"),
        )
}
