@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalConditionalBranchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property condition Configuration block for the expression to evaluate. If the condition is true, the branch's actions are taken. See `condition`.
 * @property name Name of the branch.
 * @property nextStep Configuration block for the next step in the conversation. See `next_step`.
 * @property response Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
 */
public data class V2modelsIntentClosingSettingConditionalConditionalBranchArgs(
    public val condition: Output<V2modelsIntentClosingSettingConditionalConditionalBranchConditionArgs>,
    public val name: Output<String>,
    public val nextStep: Output<V2modelsIntentClosingSettingConditionalConditionalBranchNextStepArgs>,
    public val response: Output<V2modelsIntentClosingSettingConditionalConditionalBranchResponseArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalConditionalBranchArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalConditionalBranchArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalConditionalBranchArgs.builder()
            .condition(condition.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .nextStep(nextStep.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .response(response?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentClosingSettingConditionalConditionalBranchArgs].
 */
@PulumiTagMarker
public class V2modelsIntentClosingSettingConditionalConditionalBranchArgsBuilder internal constructor() {
    private var condition:
        Output<V2modelsIntentClosingSettingConditionalConditionalBranchConditionArgs>? = null

    private var name: Output<String>? = null

    private var nextStep:
        Output<V2modelsIntentClosingSettingConditionalConditionalBranchNextStepArgs>? = null

    private var response:
        Output<V2modelsIntentClosingSettingConditionalConditionalBranchResponseArgs>? = null

    /**
     * @param value Configuration block for the expression to evaluate. If the condition is true, the branch's actions are taken. See `condition`.
     */
    @JvmName("kwckiidwutwhispd")
    public suspend fun condition(`value`: Output<V2modelsIntentClosingSettingConditionalConditionalBranchConditionArgs>) {
        this.condition = value
    }

    /**
     * @param value Name of the branch.
     */
    @JvmName("fvnlvametptybdkm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("gqukgphsuiwjtsyo")
    public suspend fun nextStep(`value`: Output<V2modelsIntentClosingSettingConditionalConditionalBranchNextStepArgs>) {
        this.nextStep = value
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("jxwabumqweuwcamp")
    public suspend fun response(`value`: Output<V2modelsIntentClosingSettingConditionalConditionalBranchResponseArgs>) {
        this.response = value
    }

    /**
     * @param value Configuration block for the expression to evaluate. If the condition is true, the branch's actions are taken. See `condition`.
     */
    @JvmName("mtvrnmiafrdrfott")
    public suspend fun condition(`value`: V2modelsIntentClosingSettingConditionalConditionalBranchConditionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param argument Configuration block for the expression to evaluate. If the condition is true, the branch's actions are taken. See `condition`.
     */
    @JvmName("ghtjflbwsptjrniy")
    public suspend fun condition(argument: suspend V2modelsIntentClosingSettingConditionalConditionalBranchConditionArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentClosingSettingConditionalConditionalBranchConditionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.condition = mapped
    }

    /**
     * @param value Name of the branch.
     */
    @JvmName("atxfjakxorwbucin")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("byghtsmslfsjhyiv")
    public suspend fun nextStep(`value`: V2modelsIntentClosingSettingConditionalConditionalBranchNextStepArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("vodpkahsdumywanv")
    public suspend fun nextStep(argument: suspend V2modelsIntentClosingSettingConditionalConditionalBranchNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentClosingSettingConditionalConditionalBranchNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.nextStep = mapped
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("gguxnalrxnxhoosx")
    public suspend fun response(`value`: V2modelsIntentClosingSettingConditionalConditionalBranchResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.response = mapped
    }

    /**
     * @param argument Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("biwlrinecganamcg")
    public suspend fun response(argument: suspend V2modelsIntentClosingSettingConditionalConditionalBranchResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentClosingSettingConditionalConditionalBranchResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.response = mapped
    }

    internal fun build(): V2modelsIntentClosingSettingConditionalConditionalBranchArgs =
        V2modelsIntentClosingSettingConditionalConditionalBranchArgs(
            condition = condition ?: throw PulumiNullFieldException("condition"),
            name = name ?: throw PulumiNullFieldException("name"),
            nextStep = nextStep ?: throw PulumiNullFieldException("nextStep"),
            response = response,
        )
}
