@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property message Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
 * @property variations Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
 */
public data class V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupArgs(
    public val message: Output<V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupMessageArgs>,
    public val variations: Output<List<V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupVariationArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupArgs.builder()
            .message(message.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .variations(
                variations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupArgs].
 */
@PulumiTagMarker
public class V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupArgsBuilder
internal constructor() {
    private var message:
        Output<V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupMessageArgs>? =
        null

    private var variations:
        Output<List<V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupVariationArgs>>? =
        null

    /**
     * @param value Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("bbtmqjeypxawanlf")
    public suspend fun message(`value`: Output<V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupMessageArgs>) {
        this.message = value
    }

    /**
     * @param value Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("fnovomhjxuksnwxp")
    public suspend fun variations(`value`: Output<List<V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupVariationArgs>>) {
        this.variations = value
    }

    @JvmName("lgjvemqgrksfajqy")
    public suspend fun variations(vararg values: Output<V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupVariationArgs>) {
        this.variations = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("epbvmeaetfwhyiwl")
    public suspend fun variations(values: List<Output<V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupVariationArgs>>) {
        this.variations = Output.all(values)
    }

    /**
     * @param value Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("qrslsomtuyvmkull")
    public suspend fun message(`value`: V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupMessageArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param argument Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("pqcfvdtooyjgeuvv")
    public suspend fun message(argument: suspend V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.message = mapped
    }

    /**
     * @param value Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("lobtyhgeatvibeea")
    public suspend fun variations(`value`: List<V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupVariationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("gjqqiybidcnyxmpc")
    public suspend fun variations(argument: List<suspend V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupVariationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("rsjlbsbvipwglakj")
    public suspend fun variations(vararg argument: suspend V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupVariationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("eoogmjklhsjdvndh")
    public suspend fun variations(argument: suspend V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupVariationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupVariationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param values Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("tbfgambthrmewuvc")
    public suspend fun variations(vararg values: V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupVariationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    internal fun build(): V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupArgs =
        V2modelsIntentClosingSettingConditionalConditionalBranchResponseMessageGroupArgs(
            message = message ?: throw PulumiNullFieldException("message"),
            variations = variations,
        )
}
