@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalDefaultBranchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property nextStep Configuration block for the next step in the conversation. See `next_step`.
 * @property response Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
 */
public data class V2modelsIntentClosingSettingConditionalDefaultBranchArgs(
    public val nextStep: Output<V2modelsIntentClosingSettingConditionalDefaultBranchNextStepArgs>? =
        null,
    public val response: Output<V2modelsIntentClosingSettingConditionalDefaultBranchResponseArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalDefaultBranchArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalDefaultBranchArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalDefaultBranchArgs.builder()
            .nextStep(nextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .response(response?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentClosingSettingConditionalDefaultBranchArgs].
 */
@PulumiTagMarker
public class V2modelsIntentClosingSettingConditionalDefaultBranchArgsBuilder internal constructor() {
    private var nextStep: Output<V2modelsIntentClosingSettingConditionalDefaultBranchNextStepArgs>? =
        null

    private var response: Output<V2modelsIntentClosingSettingConditionalDefaultBranchResponseArgs>? =
        null

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("fcmcliviraipvapo")
    public suspend fun nextStep(`value`: Output<V2modelsIntentClosingSettingConditionalDefaultBranchNextStepArgs>) {
        this.nextStep = value
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("bfkdknhgjshutgev")
    public suspend fun response(`value`: Output<V2modelsIntentClosingSettingConditionalDefaultBranchResponseArgs>) {
        this.response = value
    }

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("wrasumcqvbpsqccg")
    public suspend fun nextStep(`value`: V2modelsIntentClosingSettingConditionalDefaultBranchNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("pjhlmrvvimjukgni")
    public suspend fun nextStep(argument: suspend V2modelsIntentClosingSettingConditionalDefaultBranchNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentClosingSettingConditionalDefaultBranchNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.nextStep = mapped
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("lrkctygncbmawrre")
    public suspend fun response(`value`: V2modelsIntentClosingSettingConditionalDefaultBranchResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.response = mapped
    }

    /**
     * @param argument Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("hmebcffbysxlcext")
    public suspend fun response(argument: suspend V2modelsIntentClosingSettingConditionalDefaultBranchResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentClosingSettingConditionalDefaultBranchResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.response = mapped
    }

    internal fun build(): V2modelsIntentClosingSettingConditionalDefaultBranchArgs =
        V2modelsIntentClosingSettingConditionalDefaultBranchArgs(
            nextStep = nextStep,
            response = response,
        )
}
