@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property buttons Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
 * @property imageUrl URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
 * @property subtitle Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
 * @property title Title to display on the response card. The format of the title is determined by the platform displaying the response card.
 */
public data class
V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgs(
    public val buttons: Output<List<V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardButtonArgs>>? =
        null,
    public val imageUrl: Output<String>? = null,
    public val subtitle: Output<String>? = null,
    public val title: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgs.builder()
            .buttons(
                buttons?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .imageUrl(imageUrl?.applyValue({ args0 -> args0 }))
            .subtitle(subtitle?.applyValue({ args0 -> args0 }))
            .title(title.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgsBuilder
internal constructor() {
    private var buttons:
        Output<List<V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardButtonArgs>>? =
        null

    private var imageUrl: Output<String>? = null

    private var subtitle: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("jjxdsjgvltrbfbgd")
    public suspend fun buttons(`value`: Output<List<V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardButtonArgs>>) {
        this.buttons = value
    }

    @JvmName("jdnxggnluhumwjga")
    public suspend fun buttons(vararg values: Output<V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardButtonArgs>) {
        this.buttons = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("xpuibymcxftqfoha")
    public suspend fun buttons(values: List<Output<V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardButtonArgs>>) {
        this.buttons = Output.all(values)
    }

    /**
     * @param value URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
     */
    @JvmName("kvqkefnwvvkfqacu")
    public suspend fun imageUrl(`value`: Output<String>) {
        this.imageUrl = value
    }

    /**
     * @param value Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
     */
    @JvmName("plnssdscmwjreufe")
    public suspend fun subtitle(`value`: Output<String>) {
        this.subtitle = value
    }

    /**
     * @param value Title to display on the response card. The format of the title is determined by the platform displaying the response card.
     */
    @JvmName("jtupgrpcfaitkxlh")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("sjlarmtgvxrgxedo")
    public suspend fun buttons(`value`: List<V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardButtonArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("fongetosewyftobt")
    public suspend fun buttons(argument: List<suspend V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardButtonArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardButtonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("krvksbokawctfkqp")
    public suspend fun buttons(vararg argument: suspend V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardButtonArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardButtonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("lpgubypqahatjreq")
    public suspend fun buttons(argument: suspend V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardButtonArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardButtonArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param values Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("ppkhhhlfbqcbwgjl")
    public suspend fun buttons(vararg values: V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardButtonArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.buttons = mapped
    }

    /**
     * @param value URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
     */
    @JvmName("oymolovhreppelyt")
    public suspend fun imageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageUrl = mapped
    }

    /**
     * @param value Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
     */
    @JvmName("egwyhxydxaecvrlp")
    public suspend fun subtitle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subtitle = mapped
    }

    /**
     * @param value Title to display on the response card. The format of the title is determined by the platform displaying the response card.
     */
    @JvmName("ajvetvlosemflqsn")
    public suspend fun title(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgs =
        V2modelsIntentClosingSettingConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgs(
            buttons = buttons,
            imageUrl = imageUrl,
            subtitle = subtitle,
            title = title ?: throw PulumiNullFieldException("title"),
        )
}
