@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property active Whether the intent's confirmation is sent to the user. When this field is false, confirmation and declination responses aren't sent. If the active field isn't specified, the default is true.
 * @property codeHook Configuration block for the intent's confirmation step. The dialog code hook is triggered based on these invocation settings when the confirmation next step or declination next step or failure next step is `invoke_dialog_code_hook`.  See `code_hook`.
 * @property confirmationConditional Configuration block for conditional branches to evaluate after the intent is closed. See `confirmation_conditional`.
 * @property confirmationNextStep Configuration block for the next step that the bot executes when the customer confirms the intent. See `confirmation_next_step`.
 * @property confirmationResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `confirmation_response`.
 * @property declinationConditional Configuration block for conditional branches to evaluate after the intent is declined. See `declination_conditional`.
 * @property declinationNextStep Configuration block for the next step that the bot executes when the customer declines the intent. See `declination_next_step`.
 * @property declinationResponse Configuration block for when the user answers "no" to the question defined in `prompt_specification`, Amazon Lex responds with this response to acknowledge that the intent was canceled. See `declination_response`.
 * @property elicitationCodeHook Configuration block for when the code hook is invoked during confirmation prompt retries. See `elicitation_code_hook`.
 * @property failureConditional Configuration block for conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition. See `failure_conditional`.
 * @property failureNextStep Configuration block for the next step to take in the conversation if the confirmation step fails. See `failure_next_step`.
 * @property failureResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
 * @property promptSpecification Configuration block for prompting the user to confirm the intent. This question should have a yes or no answer. Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. See `prompt_specification`.
 */
public data class V2modelsIntentConfirmationSettingArgs(
    public val active: Output<Boolean>? = null,
    public val codeHook: Output<V2modelsIntentConfirmationSettingCodeHookArgs>? = null,
    public val confirmationConditional: Output<V2modelsIntentConfirmationSettingConfirmationConditionalArgs>? = null,
    public val confirmationNextStep: Output<V2modelsIntentConfirmationSettingConfirmationNextStepArgs>? = null,
    public val confirmationResponse: Output<V2modelsIntentConfirmationSettingConfirmationResponseArgs>? = null,
    public val declinationConditional: Output<V2modelsIntentConfirmationSettingDeclinationConditionalArgs>? = null,
    public val declinationNextStep: Output<V2modelsIntentConfirmationSettingDeclinationNextStepArgs>? =
        null,
    public val declinationResponse: Output<V2modelsIntentConfirmationSettingDeclinationResponseArgs>? =
        null,
    public val elicitationCodeHook: Output<V2modelsIntentConfirmationSettingElicitationCodeHookArgs>? =
        null,
    public val failureConditional: Output<V2modelsIntentConfirmationSettingFailureConditionalArgs>? =
        null,
    public val failureNextStep: Output<V2modelsIntentConfirmationSettingFailureNextStepArgs>? = null,
    public val failureResponse: Output<V2modelsIntentConfirmationSettingFailureResponseArgs>? = null,
    public val promptSpecification: Output<V2modelsIntentConfirmationSettingPromptSpecificationArgs>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingArgs.builder()
            .active(active?.applyValue({ args0 -> args0 }))
            .codeHook(codeHook?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .confirmationConditional(
                confirmationConditional?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .confirmationNextStep(
                confirmationNextStep?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .confirmationResponse(
                confirmationResponse?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .declinationConditional(
                declinationConditional?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .declinationNextStep(
                declinationNextStep?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .declinationResponse(
                declinationResponse?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .elicitationCodeHook(
                elicitationCodeHook?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .failureConditional(
                failureConditional?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .failureNextStep(failureNextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .failureResponse(failureResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .promptSpecification(
                promptSpecification.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingArgs].
 */
@PulumiTagMarker
public class V2modelsIntentConfirmationSettingArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var codeHook: Output<V2modelsIntentConfirmationSettingCodeHookArgs>? = null

    private var confirmationConditional:
        Output<V2modelsIntentConfirmationSettingConfirmationConditionalArgs>? = null

    private var confirmationNextStep:
        Output<V2modelsIntentConfirmationSettingConfirmationNextStepArgs>? = null

    private var confirmationResponse:
        Output<V2modelsIntentConfirmationSettingConfirmationResponseArgs>? = null

    private var declinationConditional:
        Output<V2modelsIntentConfirmationSettingDeclinationConditionalArgs>? = null

    private var declinationNextStep: Output<V2modelsIntentConfirmationSettingDeclinationNextStepArgs>? =
        null

    private var declinationResponse: Output<V2modelsIntentConfirmationSettingDeclinationResponseArgs>? =
        null

    private var elicitationCodeHook: Output<V2modelsIntentConfirmationSettingElicitationCodeHookArgs>? =
        null

    private var failureConditional: Output<V2modelsIntentConfirmationSettingFailureConditionalArgs>? =
        null

    private var failureNextStep: Output<V2modelsIntentConfirmationSettingFailureNextStepArgs>? = null

    private var failureResponse: Output<V2modelsIntentConfirmationSettingFailureResponseArgs>? = null

    private var promptSpecification: Output<V2modelsIntentConfirmationSettingPromptSpecificationArgs>? =
        null

    /**
     * @param value Whether the intent's confirmation is sent to the user. When this field is false, confirmation and declination responses aren't sent. If the active field isn't specified, the default is true.
     */
    @JvmName("orjcloiipkdgyywv")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Configuration block for the intent's confirmation step. The dialog code hook is triggered based on these invocation settings when the confirmation next step or declination next step or failure next step is `invoke_dialog_code_hook`.  See `code_hook`.
     */
    @JvmName("ylfpkgykqtpdokjb")
    public suspend fun codeHook(`value`: Output<V2modelsIntentConfirmationSettingCodeHookArgs>) {
        this.codeHook = value
    }

    /**
     * @param value Configuration block for conditional branches to evaluate after the intent is closed. See `confirmation_conditional`.
     */
    @JvmName("oppfyraiynqulpdu")
    public suspend fun confirmationConditional(`value`: Output<V2modelsIntentConfirmationSettingConfirmationConditionalArgs>) {
        this.confirmationConditional = value
    }

    /**
     * @param value Configuration block for the next step that the bot executes when the customer confirms the intent. See `confirmation_next_step`.
     */
    @JvmName("kqoakygufmaeiexc")
    public suspend fun confirmationNextStep(`value`: Output<V2modelsIntentConfirmationSettingConfirmationNextStepArgs>) {
        this.confirmationNextStep = value
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `confirmation_response`.
     */
    @JvmName("ycqxodganvdpmhsi")
    public suspend fun confirmationResponse(`value`: Output<V2modelsIntentConfirmationSettingConfirmationResponseArgs>) {
        this.confirmationResponse = value
    }

    /**
     * @param value Configuration block for conditional branches to evaluate after the intent is declined. See `declination_conditional`.
     */
    @JvmName("lunijbgtcirkwgyg")
    public suspend fun declinationConditional(`value`: Output<V2modelsIntentConfirmationSettingDeclinationConditionalArgs>) {
        this.declinationConditional = value
    }

    /**
     * @param value Configuration block for the next step that the bot executes when the customer declines the intent. See `declination_next_step`.
     */
    @JvmName("kjaytxhifpcipnpg")
    public suspend fun declinationNextStep(`value`: Output<V2modelsIntentConfirmationSettingDeclinationNextStepArgs>) {
        this.declinationNextStep = value
    }

    /**
     * @param value Configuration block for when the user answers "no" to the question defined in `prompt_specification`, Amazon Lex responds with this response to acknowledge that the intent was canceled. See `declination_response`.
     */
    @JvmName("bdbyqlvlybrghjky")
    public suspend fun declinationResponse(`value`: Output<V2modelsIntentConfirmationSettingDeclinationResponseArgs>) {
        this.declinationResponse = value
    }

    /**
     * @param value Configuration block for when the code hook is invoked during confirmation prompt retries. See `elicitation_code_hook`.
     */
    @JvmName("koylpgyfjqmcdegk")
    public suspend fun elicitationCodeHook(`value`: Output<V2modelsIntentConfirmationSettingElicitationCodeHookArgs>) {
        this.elicitationCodeHook = value
    }

    /**
     * @param value Configuration block for conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition. See `failure_conditional`.
     */
    @JvmName("xlrbphjilblmqtae")
    public suspend fun failureConditional(`value`: Output<V2modelsIntentConfirmationSettingFailureConditionalArgs>) {
        this.failureConditional = value
    }

    /**
     * @param value Configuration block for the next step to take in the conversation if the confirmation step fails. See `failure_next_step`.
     */
    @JvmName("jjkmfwmqslgyoipv")
    public suspend fun failureNextStep(`value`: Output<V2modelsIntentConfirmationSettingFailureNextStepArgs>) {
        this.failureNextStep = value
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
     */
    @JvmName("trqmdhdmliqarbji")
    public suspend fun failureResponse(`value`: Output<V2modelsIntentConfirmationSettingFailureResponseArgs>) {
        this.failureResponse = value
    }

    /**
     * @param value Configuration block for prompting the user to confirm the intent. This question should have a yes or no answer. Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. See `prompt_specification`.
     */
    @JvmName("yylswbquahdyfhtr")
    public suspend fun promptSpecification(`value`: Output<V2modelsIntentConfirmationSettingPromptSpecificationArgs>) {
        this.promptSpecification = value
    }

    /**
     * @param value Whether the intent's confirmation is sent to the user. When this field is false, confirmation and declination responses aren't sent. If the active field isn't specified, the default is true.
     */
    @JvmName("ubvrhsqkcpevjxbo")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Configuration block for the intent's confirmation step. The dialog code hook is triggered based on these invocation settings when the confirmation next step or declination next step or failure next step is `invoke_dialog_code_hook`.  See `code_hook`.
     */
    @JvmName("jiuyeyrvdenhfckg")
    public suspend fun codeHook(`value`: V2modelsIntentConfirmationSettingCodeHookArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeHook = mapped
    }

    /**
     * @param argument Configuration block for the intent's confirmation step. The dialog code hook is triggered based on these invocation settings when the confirmation next step or declination next step or failure next step is `invoke_dialog_code_hook`.  See `code_hook`.
     */
    @JvmName("bnlcggxrjrjtdgrj")
    public suspend fun codeHook(argument: suspend V2modelsIntentConfirmationSettingCodeHookArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentConfirmationSettingCodeHookArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.codeHook = mapped
    }

    /**
     * @param value Configuration block for conditional branches to evaluate after the intent is closed. See `confirmation_conditional`.
     */
    @JvmName("pswtgcqptoabegks")
    public suspend fun confirmationConditional(`value`: V2modelsIntentConfirmationSettingConfirmationConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confirmationConditional = mapped
    }

    /**
     * @param argument Configuration block for conditional branches to evaluate after the intent is closed. See `confirmation_conditional`.
     */
    @JvmName("fhhiaymrydqxosac")
    public suspend fun confirmationConditional(argument: suspend V2modelsIntentConfirmationSettingConfirmationConditionalArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingConfirmationConditionalArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.confirmationConditional = mapped
    }

    /**
     * @param value Configuration block for the next step that the bot executes when the customer confirms the intent. See `confirmation_next_step`.
     */
    @JvmName("mbnxoyrhosjpolbq")
    public suspend fun confirmationNextStep(`value`: V2modelsIntentConfirmationSettingConfirmationNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confirmationNextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step that the bot executes when the customer confirms the intent. See `confirmation_next_step`.
     */
    @JvmName("akscpvwfcfjjmqls")
    public suspend fun confirmationNextStep(argument: suspend V2modelsIntentConfirmationSettingConfirmationNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingConfirmationNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.confirmationNextStep = mapped
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `confirmation_response`.
     */
    @JvmName("hhqvxkvfdlrmogii")
    public suspend fun confirmationResponse(`value`: V2modelsIntentConfirmationSettingConfirmationResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confirmationResponse = mapped
    }

    /**
     * @param argument Configuration block for message groups that Amazon Lex uses to respond the user input. See `confirmation_response`.
     */
    @JvmName("onninvqgfvhawauv")
    public suspend fun confirmationResponse(argument: suspend V2modelsIntentConfirmationSettingConfirmationResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingConfirmationResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.confirmationResponse = mapped
    }

    /**
     * @param value Configuration block for conditional branches to evaluate after the intent is declined. See `declination_conditional`.
     */
    @JvmName("xcpmqspvgnmwwbtw")
    public suspend fun declinationConditional(`value`: V2modelsIntentConfirmationSettingDeclinationConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.declinationConditional = mapped
    }

    /**
     * @param argument Configuration block for conditional branches to evaluate after the intent is declined. See `declination_conditional`.
     */
    @JvmName("utxfyltirdxmrqvc")
    public suspend fun declinationConditional(argument: suspend V2modelsIntentConfirmationSettingDeclinationConditionalArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingDeclinationConditionalArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.declinationConditional = mapped
    }

    /**
     * @param value Configuration block for the next step that the bot executes when the customer declines the intent. See `declination_next_step`.
     */
    @JvmName("jpepuhpoubonfqjb")
    public suspend fun declinationNextStep(`value`: V2modelsIntentConfirmationSettingDeclinationNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.declinationNextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step that the bot executes when the customer declines the intent. See `declination_next_step`.
     */
    @JvmName("rebgitnmimqlirsq")
    public suspend fun declinationNextStep(argument: suspend V2modelsIntentConfirmationSettingDeclinationNextStepArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentConfirmationSettingDeclinationNextStepArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.declinationNextStep = mapped
    }

    /**
     * @param value Configuration block for when the user answers "no" to the question defined in `prompt_specification`, Amazon Lex responds with this response to acknowledge that the intent was canceled. See `declination_response`.
     */
    @JvmName("quobqudugrauygpb")
    public suspend fun declinationResponse(`value`: V2modelsIntentConfirmationSettingDeclinationResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.declinationResponse = mapped
    }

    /**
     * @param argument Configuration block for when the user answers "no" to the question defined in `prompt_specification`, Amazon Lex responds with this response to acknowledge that the intent was canceled. See `declination_response`.
     */
    @JvmName("abjbbiquufamjnhg")
    public suspend fun declinationResponse(argument: suspend V2modelsIntentConfirmationSettingDeclinationResponseArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentConfirmationSettingDeclinationResponseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.declinationResponse = mapped
    }

    /**
     * @param value Configuration block for when the code hook is invoked during confirmation prompt retries. See `elicitation_code_hook`.
     */
    @JvmName("pcotlfcgvenetauf")
    public suspend fun elicitationCodeHook(`value`: V2modelsIntentConfirmationSettingElicitationCodeHookArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elicitationCodeHook = mapped
    }

    /**
     * @param argument Configuration block for when the code hook is invoked during confirmation prompt retries. See `elicitation_code_hook`.
     */
    @JvmName("kwajbehskwwtfdsh")
    public suspend fun elicitationCodeHook(argument: suspend V2modelsIntentConfirmationSettingElicitationCodeHookArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentConfirmationSettingElicitationCodeHookArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.elicitationCodeHook = mapped
    }

    /**
     * @param value Configuration block for conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition. See `failure_conditional`.
     */
    @JvmName("staebmnydpnakuwf")
    public suspend fun failureConditional(`value`: V2modelsIntentConfirmationSettingFailureConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureConditional = mapped
    }

    /**
     * @param argument Configuration block for conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition. See `failure_conditional`.
     */
    @JvmName("xkyynuxucmybpvre")
    public suspend fun failureConditional(argument: suspend V2modelsIntentConfirmationSettingFailureConditionalArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentConfirmationSettingFailureConditionalArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.failureConditional = mapped
    }

    /**
     * @param value Configuration block for the next step to take in the conversation if the confirmation step fails. See `failure_next_step`.
     */
    @JvmName("bbtppdukvxqkdqjo")
    public suspend fun failureNextStep(`value`: V2modelsIntentConfirmationSettingFailureNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureNextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step to take in the conversation if the confirmation step fails. See `failure_next_step`.
     */
    @JvmName("pjubcybbagdmvilu")
    public suspend fun failureNextStep(argument: suspend V2modelsIntentConfirmationSettingFailureNextStepArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentConfirmationSettingFailureNextStepArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.failureNextStep = mapped
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
     */
    @JvmName("nllhpatydlvgxkww")
    public suspend fun failureResponse(`value`: V2modelsIntentConfirmationSettingFailureResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureResponse = mapped
    }

    /**
     * @param argument Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
     */
    @JvmName("uvfqvpxoqnnfbpqo")
    public suspend fun failureResponse(argument: suspend V2modelsIntentConfirmationSettingFailureResponseArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentConfirmationSettingFailureResponseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.failureResponse = mapped
    }

    /**
     * @param value Configuration block for prompting the user to confirm the intent. This question should have a yes or no answer. Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. See `prompt_specification`.
     */
    @JvmName("gdguanpmculbbpgv")
    public suspend fun promptSpecification(`value`: V2modelsIntentConfirmationSettingPromptSpecificationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.promptSpecification = mapped
    }

    /**
     * @param argument Configuration block for prompting the user to confirm the intent. This question should have a yes or no answer. Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. See `prompt_specification`.
     */
    @JvmName("pnpybaqygdumlxhs")
    public suspend fun promptSpecification(argument: suspend V2modelsIntentConfirmationSettingPromptSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentConfirmationSettingPromptSpecificationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.promptSpecification = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingArgs =
        V2modelsIntentConfirmationSettingArgs(
            active = active,
            codeHook = codeHook,
            confirmationConditional = confirmationConditional,
            confirmationNextStep = confirmationNextStep,
            confirmationResponse = confirmationResponse,
            declinationConditional = declinationConditional,
            declinationNextStep = declinationNextStep,
            declinationResponse = declinationResponse,
            elicitationCodeHook = elicitationCodeHook,
            failureConditional = failureConditional,
            failureNextStep = failureNextStep,
            failureResponse = failureResponse,
            promptSpecification = promptSpecification ?: throw PulumiNullFieldException("promptSpecification"),
        )
}
