@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingCodeHookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property active Whether a dialog code hook is used when the intent is activated.
 * @property enableCodeHookInvocation Whether a Lambda function should be invoked for the dialog.
 * @property invocationLabel Label that indicates the dialog step from which the dialog code hook is happening.
 * @property postCodeHookSpecification Configuration block that contains the responses and actions that Amazon Lex takes after the Lambda function is complete. See `post_code_hook_specification`.
 */
public data class V2modelsIntentConfirmationSettingCodeHookArgs(
    public val active: Output<Boolean>,
    public val enableCodeHookInvocation: Output<Boolean>,
    public val invocationLabel: Output<String>? = null,
    public val postCodeHookSpecification: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgs>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingCodeHookArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingCodeHookArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingCodeHookArgs.builder()
            .active(active.applyValue({ args0 -> args0 }))
            .enableCodeHookInvocation(enableCodeHookInvocation.applyValue({ args0 -> args0 }))
            .invocationLabel(invocationLabel?.applyValue({ args0 -> args0 }))
            .postCodeHookSpecification(
                postCodeHookSpecification.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingCodeHookArgs].
 */
@PulumiTagMarker
public class V2modelsIntentConfirmationSettingCodeHookArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var enableCodeHookInvocation: Output<Boolean>? = null

    private var invocationLabel: Output<String>? = null

    private var postCodeHookSpecification:
        Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgs>? = null

    /**
     * @param value Whether a dialog code hook is used when the intent is activated.
     */
    @JvmName("pgbcmuvvmgaxlhxv")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Whether a Lambda function should be invoked for the dialog.
     */
    @JvmName("rfvcjipbrmrpadms")
    public suspend fun enableCodeHookInvocation(`value`: Output<Boolean>) {
        this.enableCodeHookInvocation = value
    }

    /**
     * @param value Label that indicates the dialog step from which the dialog code hook is happening.
     */
    @JvmName("hhpnuvrpgbomcmkv")
    public suspend fun invocationLabel(`value`: Output<String>) {
        this.invocationLabel = value
    }

    /**
     * @param value Configuration block that contains the responses and actions that Amazon Lex takes after the Lambda function is complete. See `post_code_hook_specification`.
     */
    @JvmName("fwlyhumxdehxipbv")
    public suspend fun postCodeHookSpecification(`value`: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgs>) {
        this.postCodeHookSpecification = value
    }

    /**
     * @param value Whether a dialog code hook is used when the intent is activated.
     */
    @JvmName("ciibctgbuxqlniqe")
    public suspend fun active(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Whether a Lambda function should be invoked for the dialog.
     */
    @JvmName("xripqwacpjyfbobk")
    public suspend fun enableCodeHookInvocation(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableCodeHookInvocation = mapped
    }

    /**
     * @param value Label that indicates the dialog step from which the dialog code hook is happening.
     */
    @JvmName("opwlvwknjkngyqwm")
    public suspend fun invocationLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invocationLabel = mapped
    }

    /**
     * @param value Configuration block that contains the responses and actions that Amazon Lex takes after the Lambda function is complete. See `post_code_hook_specification`.
     */
    @JvmName("lyjfrlvunsnfxulv")
    public suspend fun postCodeHookSpecification(`value`: V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.postCodeHookSpecification = mapped
    }

    /**
     * @param argument Configuration block that contains the responses and actions that Amazon Lex takes after the Lambda function is complete. See `post_code_hook_specification`.
     */
    @JvmName("wmovgxpxridumkkn")
    public suspend fun postCodeHookSpecification(argument: suspend V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.postCodeHookSpecification = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingCodeHookArgs =
        V2modelsIntentConfirmationSettingCodeHookArgs(
            active = active ?: throw PulumiNullFieldException("active"),
            enableCodeHookInvocation = enableCodeHookInvocation ?: throw
                PulumiNullFieldException("enableCodeHookInvocation"),
            invocationLabel = invocationLabel,
            postCodeHookSpecification = postCodeHookSpecification ?: throw
                PulumiNullFieldException("postCodeHookSpecification"),
        )
}
