@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property failureConditional Configuration block for conditional branches to evaluate after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed.
 * @property failureNextStep Configuration block for the next step the bot runs after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed . See `failure_next_step`.
 * @property failureResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
 * @property successConditional Configuration block for conditional branches to evaluate after the dialog code hook finishes successfully. See `success_conditional`.
 * @property successNextStep Configuration block for the next step the bot runs after the dialog code hook finishes successfully. See `success_next_step`.
 * @property successResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `success_response`.
 * @property timeoutConditional Configuration block for conditional branches to evaluate if the code hook times out. See `timeout_conditional`.
 * @property timeoutNextStep Configuration block for the next step that the bot runs when the code hook times out. See `timeout_next_step`.
 * @property timeoutResponse Configuration block for a list of message groups that Amazon Lex uses to respond the user input. See `timeout_response`.
 */
public data class V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgs(
    public val failureConditional: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureConditionalArgs>? =
        null,
    public val failureNextStep: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureNextStepArgs>? =
        null,
    public val failureResponse: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureResponseArgs>? =
        null,
    public val successConditional: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessConditionalArgs>? =
        null,
    public val successNextStep: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessNextStepArgs>? =
        null,
    public val successResponse: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessResponseArgs>? =
        null,
    public val timeoutConditional: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutConditionalArgs>? =
        null,
    public val timeoutNextStep: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutNextStepArgs>? =
        null,
    public val timeoutResponse: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutResponseArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgs.builder()
            .failureConditional(
                failureConditional?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .failureNextStep(failureNextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .failureResponse(failureResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .successConditional(
                successConditional?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .successNextStep(successNextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .successResponse(successResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeoutConditional(
                timeoutConditional?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .timeoutNextStep(timeoutNextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeoutResponse(
                timeoutResponse?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgs].
 */
@PulumiTagMarker
public class V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgsBuilder internal constructor() {
    private var failureConditional:
        Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureConditionalArgs>? =
        null

    private var failureNextStep:
        Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureNextStepArgs>? =
        null

    private var failureResponse:
        Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureResponseArgs>? =
        null

    private var successConditional:
        Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessConditionalArgs>? =
        null

    private var successNextStep:
        Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessNextStepArgs>? =
        null

    private var successResponse:
        Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessResponseArgs>? =
        null

    private var timeoutConditional:
        Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutConditionalArgs>? =
        null

    private var timeoutNextStep:
        Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutNextStepArgs>? =
        null

    private var timeoutResponse:
        Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutResponseArgs>? =
        null

    /**
     * @param value Configuration block for conditional branches to evaluate after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed.
     */
    @JvmName("pscunnajosynclur")
    public suspend fun failureConditional(`value`: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureConditionalArgs>) {
        this.failureConditional = value
    }

    /**
     * @param value Configuration block for the next step the bot runs after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed . See `failure_next_step`.
     */
    @JvmName("vuylippjlafakpsn")
    public suspend fun failureNextStep(`value`: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureNextStepArgs>) {
        this.failureNextStep = value
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
     */
    @JvmName("vamhrxfgspfpdcro")
    public suspend fun failureResponse(`value`: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureResponseArgs>) {
        this.failureResponse = value
    }

    /**
     * @param value Configuration block for conditional branches to evaluate after the dialog code hook finishes successfully. See `success_conditional`.
     */
    @JvmName("bqdpsyyjywufafda")
    public suspend fun successConditional(`value`: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessConditionalArgs>) {
        this.successConditional = value
    }

    /**
     * @param value Configuration block for the next step the bot runs after the dialog code hook finishes successfully. See `success_next_step`.
     */
    @JvmName("wiuyieyinlwnaxrx")
    public suspend fun successNextStep(`value`: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessNextStepArgs>) {
        this.successNextStep = value
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `success_response`.
     */
    @JvmName("cdyrpgmlijbgnxvb")
    public suspend fun successResponse(`value`: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessResponseArgs>) {
        this.successResponse = value
    }

    /**
     * @param value Configuration block for conditional branches to evaluate if the code hook times out. See `timeout_conditional`.
     */
    @JvmName("mwivwpjhrtixrdyf")
    public suspend fun timeoutConditional(`value`: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutConditionalArgs>) {
        this.timeoutConditional = value
    }

    /**
     * @param value Configuration block for the next step that the bot runs when the code hook times out. See `timeout_next_step`.
     */
    @JvmName("uvxvixcpdlgoyatr")
    public suspend fun timeoutNextStep(`value`: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutNextStepArgs>) {
        this.timeoutNextStep = value
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond the user input. See `timeout_response`.
     */
    @JvmName("ypfpkshabtplemph")
    public suspend fun timeoutResponse(`value`: Output<V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutResponseArgs>) {
        this.timeoutResponse = value
    }

    /**
     * @param value Configuration block for conditional branches to evaluate after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed.
     */
    @JvmName("kdafsunibwhttfdn")
    public suspend fun failureConditional(`value`: V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureConditional = mapped
    }

    /**
     * @param argument Configuration block for conditional branches to evaluate after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed.
     */
    @JvmName("pjpllqsmfamkeeut")
    public suspend fun failureConditional(argument: suspend V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureConditionalArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureConditionalArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.failureConditional = mapped
    }

    /**
     * @param value Configuration block for the next step the bot runs after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed . See `failure_next_step`.
     */
    @JvmName("nqeouiewokvlgodt")
    public suspend fun failureNextStep(`value`: V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureNextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step the bot runs after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed . See `failure_next_step`.
     */
    @JvmName("nfwptoapfjwknvop")
    public suspend fun failureNextStep(argument: suspend V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.failureNextStep = mapped
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
     */
    @JvmName("xsfaknrjgcekdkgr")
    public suspend fun failureResponse(`value`: V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureResponse = mapped
    }

    /**
     * @param argument Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
     */
    @JvmName("phfkksedpgdjplru")
    public suspend fun failureResponse(argument: suspend V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationFailureResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.failureResponse = mapped
    }

    /**
     * @param value Configuration block for conditional branches to evaluate after the dialog code hook finishes successfully. See `success_conditional`.
     */
    @JvmName("fcbnfmctwtesrfuv")
    public suspend fun successConditional(`value`: V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successConditional = mapped
    }

    /**
     * @param argument Configuration block for conditional branches to evaluate after the dialog code hook finishes successfully. See `success_conditional`.
     */
    @JvmName("dulcjmtblmntsjvg")
    public suspend fun successConditional(argument: suspend V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessConditionalArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessConditionalArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.successConditional = mapped
    }

    /**
     * @param value Configuration block for the next step the bot runs after the dialog code hook finishes successfully. See `success_next_step`.
     */
    @JvmName("tgvpoetbupkqhtgm")
    public suspend fun successNextStep(`value`: V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successNextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step the bot runs after the dialog code hook finishes successfully. See `success_next_step`.
     */
    @JvmName("ysrfatntrnprypsk")
    public suspend fun successNextStep(argument: suspend V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.successNextStep = mapped
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `success_response`.
     */
    @JvmName("hargphqqcguatpww")
    public suspend fun successResponse(`value`: V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successResponse = mapped
    }

    /**
     * @param argument Configuration block for message groups that Amazon Lex uses to respond the user input. See `success_response`.
     */
    @JvmName("wxrbtaouvfwkntfq")
    public suspend fun successResponse(argument: suspend V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationSuccessResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.successResponse = mapped
    }

    /**
     * @param value Configuration block for conditional branches to evaluate if the code hook times out. See `timeout_conditional`.
     */
    @JvmName("fhhriqminjigkyqv")
    public suspend fun timeoutConditional(`value`: V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutConditional = mapped
    }

    /**
     * @param argument Configuration block for conditional branches to evaluate if the code hook times out. See `timeout_conditional`.
     */
    @JvmName("knufldjbixdlslel")
    public suspend fun timeoutConditional(argument: suspend V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutConditionalArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutConditionalArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeoutConditional = mapped
    }

    /**
     * @param value Configuration block for the next step that the bot runs when the code hook times out. See `timeout_next_step`.
     */
    @JvmName("ajxntsbpggjhkwlv")
    public suspend fun timeoutNextStep(`value`: V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutNextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step that the bot runs when the code hook times out. See `timeout_next_step`.
     */
    @JvmName("snlfyfxjxbepvvak")
    public suspend fun timeoutNextStep(argument: suspend V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeoutNextStep = mapped
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond the user input. See `timeout_response`.
     */
    @JvmName("sgahfmaaimvjvkyo")
    public suspend fun timeoutResponse(`value`: V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutResponse = mapped
    }

    /**
     * @param argument Configuration block for a list of message groups that Amazon Lex uses to respond the user input. See `timeout_response`.
     */
    @JvmName("rakwubaxawvwmomr")
    public suspend fun timeoutResponse(argument: suspend V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationTimeoutResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeoutResponse = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgs =
        V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecificationArgs(
            failureConditional = failureConditional,
            failureNextStep = failureNextStep,
            failureResponse = failureResponse,
            successConditional = successConditional,
            successNextStep = successNextStep,
            successResponse = successResponse,
            timeoutConditional = timeoutConditional,
            timeoutNextStep = timeoutNextStep,
            timeoutResponse = timeoutResponse,
        )
}
