@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the intent.
 * @property slots Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
 */
public data class
V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentArgs(
    public val name: Output<String>? = null,
    public val slots: Output<List<V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentSlotArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .slots(
                slots?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentArgsBuilder
internal constructor() {
    private var name: Output<String>? = null

    private var slots:
        Output<List<V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentSlotArgs>>? =
        null

    /**
     * @param value Name of the intent.
     */
    @JvmName("msfuixosqqhdlykx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("uanystsmfikpigxe")
    public suspend fun slots(`value`: Output<List<V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentSlotArgs>>) {
        this.slots = value
    }

    @JvmName("bvknrwylosllsnve")
    public suspend fun slots(vararg values: Output<V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentSlotArgs>) {
        this.slots = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("dyrdkkjjvyouaaak")
    public suspend fun slots(values: List<Output<V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentSlotArgs>>) {
        this.slots = Output.all(values)
    }

    /**
     * @param value Name of the intent.
     */
    @JvmName("oxnbksblkluirrso")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("xliprxedamdptocp")
    public suspend fun slots(`value`: List<V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentSlotArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slots = mapped
    }

    /**
     * @param argument Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("fyyuibsitxncgdle")
    public suspend fun slots(argument: List<suspend V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentSlotArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentSlotArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param argument Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("jpojkreegiyulpla")
    public suspend fun slots(vararg argument: suspend V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentSlotArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentSlotArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param argument Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("djmohkitudoivbqg")
    public suspend fun slots(argument: suspend V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentSlotArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentSlotArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param values Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("yfsmgtfvwemlaiof")
    public suspend fun slots(vararg values: V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentSlotArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slots = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentArgs =
        V2modelsIntentConfirmationSettingConfirmationConditionalConditionalBranchNextStepIntentArgs(
            name = name,
            slots = slots,
        )
}
