@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property nextStep Configuration block for the next step in the conversation. See `next_step`.
 * @property response Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
 */
public data class V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchArgs(
    public val nextStep: Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepArgs>? =
        null,
    public val response: Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchArgs.builder()
            .nextStep(nextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .response(response?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchArgs].
 */
@PulumiTagMarker
public class V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchArgsBuilder
internal constructor() {
    private var nextStep:
        Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepArgs>? =
        null

    private var response:
        Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseArgs>? =
        null

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("soxgcoshpkhplajy")
    public suspend fun nextStep(`value`: Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepArgs>) {
        this.nextStep = value
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("wiffobdopdyfnhsb")
    public suspend fun response(`value`: Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseArgs>) {
        this.response = value
    }

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("nrvwvhibjepbjjda")
    public suspend fun nextStep(`value`: V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("wrqbabhkomljvdrm")
    public suspend fun nextStep(argument: suspend V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.nextStep = mapped
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("mhvusqjtrxfvcesw")
    public suspend fun response(`value`: V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.response = mapped
    }

    /**
     * @param argument Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("pgkwmchtkjbxhyvx")
    public suspend fun response(argument: suspend V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.response = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchArgs =
        V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchArgs(
            nextStep = nextStep,
            response = response,
        )
}
