@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the intent.
 * @property slots Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
 */
public data class
V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentArgs(
    public val name: Output<String>? = null,
    public val slots: Output<List<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentSlotArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .slots(
                slots?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentArgsBuilder
internal constructor() {
    private var name: Output<String>? = null

    private var slots:
        Output<List<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentSlotArgs>>? =
        null

    /**
     * @param value Name of the intent.
     */
    @JvmName("tqvvxhutrayaqmnl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("qtmqklimqsrdcoly")
    public suspend fun slots(`value`: Output<List<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentSlotArgs>>) {
        this.slots = value
    }

    @JvmName("yigxrcbpfcejrcwx")
    public suspend fun slots(vararg values: Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentSlotArgs>) {
        this.slots = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("cnwuwdpfmnfjljls")
    public suspend fun slots(values: List<Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentSlotArgs>>) {
        this.slots = Output.all(values)
    }

    /**
     * @param value Name of the intent.
     */
    @JvmName("hpixqoevibiqkwsv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("ilyhyoseqcpkysuu")
    public suspend fun slots(`value`: List<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentSlotArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slots = mapped
    }

    /**
     * @param argument Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("okdebqkwxcciomla")
    public suspend fun slots(argument: List<suspend V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentSlotArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentSlotArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param argument Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("fmmrcwnsbvvadwvt")
    public suspend fun slots(vararg argument: suspend V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentSlotArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentSlotArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param argument Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("tpgwauswwstixpxr")
    public suspend fun slots(argument: suspend V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentSlotArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentSlotArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param values Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("ogqtayrodvucjmtf")
    public suspend fun slots(vararg values: V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentSlotArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slots = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentArgs =
        V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchNextStepIntentArgs(
            name = name,
            slots = slots,
        )
}
