@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customPayload Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
 * @property imageResponseCard Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
 * @property plainTextMessage Configuration block for a message in plain text format. See `plain_text_message`.
 * @property ssmlMessage Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
 */
public data class
V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageArgs(
    public val customPayload: Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageCustomPayloadArgs>? =
        null,
    public val imageResponseCard: Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgs>? =
        null,
    public val plainTextMessage: Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessagePlainTextMessageArgs>? =
        null,
    public val ssmlMessage: Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageSsmlMessageArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageArgs.builder()
            .customPayload(customPayload?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageResponseCard(imageResponseCard?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .plainTextMessage(plainTextMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ssmlMessage(ssmlMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageArgsBuilder
internal constructor() {
    private var customPayload:
        Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageCustomPayloadArgs>? =
        null

    private var imageResponseCard:
        Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgs>? =
        null

    private var plainTextMessage:
        Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessagePlainTextMessageArgs>? =
        null

    private var ssmlMessage:
        Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageSsmlMessageArgs>? =
        null

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("hcakaxmvqosuskdn")
    public suspend fun customPayload(`value`: Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageCustomPayloadArgs>) {
        this.customPayload = value
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("eujkfqxrwwjwjavl")
    public suspend fun imageResponseCard(`value`: Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgs>) {
        this.imageResponseCard = value
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("yphbkpbwsipsailh")
    public suspend fun plainTextMessage(`value`: Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessagePlainTextMessageArgs>) {
        this.plainTextMessage = value
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("ugnksmwoyruedgtf")
    public suspend fun ssmlMessage(`value`: Output<V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageSsmlMessageArgs>) {
        this.ssmlMessage = value
    }

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("lvpqsadleekjcrcu")
    public suspend fun customPayload(`value`: V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageCustomPayloadArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPayload = mapped
    }

    /**
     * @param argument Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("gybmnxxiccxxfgbo")
    public suspend fun customPayload(argument: suspend V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageCustomPayloadArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageCustomPayloadArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customPayload = mapped
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("cbcjkhltythycide")
    public suspend fun imageResponseCard(`value`: V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageResponseCard = mapped
    }

    /**
     * @param argument Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("gsrpuinyvkdnluji")
    public suspend fun imageResponseCard(argument: suspend V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageImageResponseCardArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.imageResponseCard = mapped
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("bwlbqbprqrjrkxky")
    public suspend fun plainTextMessage(`value`: V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessagePlainTextMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plainTextMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("mmxwbfwfauytqbug")
    public suspend fun plainTextMessage(argument: suspend V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessagePlainTextMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessagePlainTextMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.plainTextMessage = mapped
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("cbiyjsdnkxeyhtgj")
    public suspend fun ssmlMessage(`value`: V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageSsmlMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssmlMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("sdndouvudxcsgqst")
    public suspend fun ssmlMessage(argument: suspend V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageSsmlMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageSsmlMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ssmlMessage = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageArgs =
        V2modelsIntentConfirmationSettingConfirmationConditionalDefaultBranchResponseMessageGroupMessageArgs(
            customPayload = customPayload,
            imageResponseCard = imageResponseCard,
            plainTextMessage = plainTextMessage,
            ssmlMessage = ssmlMessage,
        )
}
