@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customPayload Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
 * @property imageResponseCard Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
 * @property plainTextMessage Configuration block for a message in plain text format. See `plain_text_message`.
 * @property ssmlMessage Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
 */
public data class
V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageArgs(
    public val customPayload: Output<V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgs>? =
        null,
    public val imageResponseCard: Output<V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs>? =
        null,
    public val plainTextMessage: Output<V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgs>? =
        null,
    public val ssmlMessage: Output<V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageArgs.builder()
            .customPayload(customPayload?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageResponseCard(imageResponseCard?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .plainTextMessage(plainTextMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ssmlMessage(ssmlMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageArgsBuilder
internal constructor() {
    private var customPayload:
        Output<V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgs>? =
        null

    private var imageResponseCard:
        Output<V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs>? =
        null

    private var plainTextMessage:
        Output<V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgs>? =
        null

    private var ssmlMessage:
        Output<V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgs>? =
        null

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("ijknoghepsjgsbyc")
    public suspend fun customPayload(`value`: Output<V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgs>) {
        this.customPayload = value
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("phntuoywlcxcsmjs")
    public suspend fun imageResponseCard(`value`: Output<V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs>) {
        this.imageResponseCard = value
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("nkicwqsibtvpksvm")
    public suspend fun plainTextMessage(`value`: Output<V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgs>) {
        this.plainTextMessage = value
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("mqlvvawmhvaixsmo")
    public suspend fun ssmlMessage(`value`: Output<V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgs>) {
        this.ssmlMessage = value
    }

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("irugvifpqmmpgpba")
    public suspend fun customPayload(`value`: V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPayload = mapped
    }

    /**
     * @param argument Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("mytklvjugpethvmg")
    public suspend fun customPayload(argument: suspend V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customPayload = mapped
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("qkwnfvtnlwrtsnkp")
    public suspend fun imageResponseCard(`value`: V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageResponseCard = mapped
    }

    /**
     * @param argument Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("rybbqdvtajxrxobp")
    public suspend fun imageResponseCard(argument: suspend V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.imageResponseCard = mapped
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("jwpjehsinakqeuad")
    public suspend fun plainTextMessage(`value`: V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plainTextMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("vlruxoebsdipkdsd")
    public suspend fun plainTextMessage(argument: suspend V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.plainTextMessage = mapped
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("fmbwgxkcggunojaw")
    public suspend fun ssmlMessage(`value`: V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssmlMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("oumrqepdrfpmdamu")
    public suspend fun ssmlMessage(argument: suspend V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ssmlMessage = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageArgs =
        V2modelsIntentConfirmationSettingDeclinationConditionalConditionalBranchResponseMessageGroupMessageArgs(
            customPayload = customPayload,
            imageResponseCard = imageResponseCard,
            plainTextMessage = plainTextMessage,
            ssmlMessage = ssmlMessage,
        )
}
