@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property nextStep Configuration block for the next step in the conversation. See `next_step`.
 * @property response Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
 */
public data class V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchArgs(
    public val nextStep: Output<V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchNextStepArgs>? =
        null,
    public val response: Output<V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchArgs.builder()
            .nextStep(nextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .response(response?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchArgs].
 */
@PulumiTagMarker
public class V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchArgsBuilder
internal constructor() {
    private var nextStep:
        Output<V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchNextStepArgs>? =
        null

    private var response:
        Output<V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgs>? =
        null

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("gnsowenjwtioivqq")
    public suspend fun nextStep(`value`: Output<V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchNextStepArgs>) {
        this.nextStep = value
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("vwtmnqlqjsjadmde")
    public suspend fun response(`value`: Output<V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgs>) {
        this.response = value
    }

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("blpspkcdvgnwxgwi")
    public suspend fun nextStep(`value`: V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("nxydewjgushfoqhx")
    public suspend fun nextStep(argument: suspend V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.nextStep = mapped
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("xmqnnnkpbswpuipm")
    public suspend fun response(`value`: V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.response = mapped
    }

    /**
     * @param argument Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("gloxdxrwlarlegir")
    public suspend fun response(argument: suspend V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.response = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchArgs =
        V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchArgs(
            nextStep = nextStep,
            response = response,
        )
}
