@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowInterrupt Whether the user can interrupt a speech response from Amazon Lex.
 * @property messageGroups Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
 */
public data class V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgs(
    public val allowInterrupt: Output<Boolean>? = null,
    public val messageGroups: Output<List<V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseMessageGroupArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgs.builder()
            .allowInterrupt(allowInterrupt?.applyValue({ args0 -> args0 }))
            .messageGroups(
                messageGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgs].
 */
@PulumiTagMarker
public class V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgsBuilder
internal constructor() {
    private var allowInterrupt: Output<Boolean>? = null

    private var messageGroups:
        Output<List<V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseMessageGroupArgs>>? =
        null

    /**
     * @param value Whether the user can interrupt a speech response from Amazon Lex.
     */
    @JvmName("wqpsxjmprdtfarmt")
    public suspend fun allowInterrupt(`value`: Output<Boolean>) {
        this.allowInterrupt = value
    }

    /**
     * @param value Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("iaalvrbgvvpbjxvy")
    public suspend fun messageGroups(`value`: Output<List<V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseMessageGroupArgs>>) {
        this.messageGroups = value
    }

    @JvmName("vkaphtypxvwfxybe")
    public suspend fun messageGroups(vararg values: Output<V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseMessageGroupArgs>) {
        this.messageGroups = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("frhvyhsbaajixvrk")
    public suspend fun messageGroups(values: List<Output<V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseMessageGroupArgs>>) {
        this.messageGroups = Output.all(values)
    }

    /**
     * @param value Whether the user can interrupt a speech response from Amazon Lex.
     */
    @JvmName("oskctxloehlxdggu")
    public suspend fun allowInterrupt(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowInterrupt = mapped
    }

    /**
     * @param value Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("yakvweaxaxghvjco")
    public suspend fun messageGroups(`value`: List<V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseMessageGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageGroups = mapped
    }

    /**
     * @param argument Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("wmslhsgrajfsmeas")
    public suspend fun messageGroups(argument: List<suspend V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseMessageGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseMessageGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param argument Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("iiqyjxcclpcdospm")
    public suspend fun messageGroups(vararg argument: suspend V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseMessageGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseMessageGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param argument Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("owjwijklfhfggyqc")
    public suspend fun messageGroups(argument: suspend V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseMessageGroupArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseMessageGroupArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param values Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("agwhysdrpbgkpvjd")
    public suspend fun messageGroups(vararg values: V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseMessageGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageGroups = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgs =
        V2modelsIntentConfirmationSettingDeclinationConditionalDefaultBranchResponseArgs(
            allowInterrupt = allowInterrupt,
            messageGroups = messageGroups,
        )
}
