@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingElicitationCodeHookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableCodeHookInvocation Whether a Lambda function should be invoked for the dialog.
 * @property invocationLabel Label that indicates the dialog step from which the dialog code hook is happening.
 */
public data class V2modelsIntentConfirmationSettingElicitationCodeHookArgs(
    public val enableCodeHookInvocation: Output<Boolean>? = null,
    public val invocationLabel: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingElicitationCodeHookArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingElicitationCodeHookArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingElicitationCodeHookArgs.builder()
            .enableCodeHookInvocation(enableCodeHookInvocation?.applyValue({ args0 -> args0 }))
            .invocationLabel(invocationLabel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingElicitationCodeHookArgs].
 */
@PulumiTagMarker
public class V2modelsIntentConfirmationSettingElicitationCodeHookArgsBuilder internal constructor() {
    private var enableCodeHookInvocation: Output<Boolean>? = null

    private var invocationLabel: Output<String>? = null

    /**
     * @param value Whether a Lambda function should be invoked for the dialog.
     */
    @JvmName("eicoxctnrqhjvovf")
    public suspend fun enableCodeHookInvocation(`value`: Output<Boolean>) {
        this.enableCodeHookInvocation = value
    }

    /**
     * @param value Label that indicates the dialog step from which the dialog code hook is happening.
     */
    @JvmName("khgnsrlvlrqkthcb")
    public suspend fun invocationLabel(`value`: Output<String>) {
        this.invocationLabel = value
    }

    /**
     * @param value Whether a Lambda function should be invoked for the dialog.
     */
    @JvmName("ejpfnfcpslnvdodr")
    public suspend fun enableCodeHookInvocation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCodeHookInvocation = mapped
    }

    /**
     * @param value Label that indicates the dialog step from which the dialog code hook is happening.
     */
    @JvmName("ewgroibcpckegosk")
    public suspend fun invocationLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invocationLabel = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingElicitationCodeHookArgs =
        V2modelsIntentConfirmationSettingElicitationCodeHookArgs(
            enableCodeHookInvocation = enableCodeHookInvocation,
            invocationLabel = invocationLabel,
        )
}
