@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureConditionalArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property active Whether a conditional branch is active. When active is false, the conditions are not evaluated.
 * @property conditionalBranches Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
 * @property defaultBranch Configuration block for the conditional branch that should be followed when the conditions for other branches are not satisfied. A branch is made up of a condition, a response and a next step. See `default_branch`.
 */
public data class V2modelsIntentConfirmationSettingFailureConditionalArgs(
    public val active: Output<Boolean>,
    public val conditionalBranches: Output<List<V2modelsIntentConfirmationSettingFailureConditionalConditionalBranchArgs>>? =
        null,
    public val defaultBranch: Output<V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureConditionalArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureConditionalArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureConditionalArgs.builder()
            .active(active.applyValue({ args0 -> args0 }))
            .conditionalBranches(
                conditionalBranches?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .defaultBranch(defaultBranch.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingFailureConditionalArgs].
 */
@PulumiTagMarker
public class V2modelsIntentConfirmationSettingFailureConditionalArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var conditionalBranches:
        Output<List<V2modelsIntentConfirmationSettingFailureConditionalConditionalBranchArgs>>? = null

    private var defaultBranch:
        Output<V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgs>? = null

    /**
     * @param value Whether a conditional branch is active. When active is false, the conditions are not evaluated.
     */
    @JvmName("regrjybrcffonliw")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("qymarttxxwlsanpm")
    public suspend fun conditionalBranches(`value`: Output<List<V2modelsIntentConfirmationSettingFailureConditionalConditionalBranchArgs>>) {
        this.conditionalBranches = value
    }

    @JvmName("ujtwqueysphcuoam")
    public suspend fun conditionalBranches(vararg values: Output<V2modelsIntentConfirmationSettingFailureConditionalConditionalBranchArgs>) {
        this.conditionalBranches = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("qpwmtpmypvlwrase")
    public suspend fun conditionalBranches(values: List<Output<V2modelsIntentConfirmationSettingFailureConditionalConditionalBranchArgs>>) {
        this.conditionalBranches = Output.all(values)
    }

    /**
     * @param value Configuration block for the conditional branch that should be followed when the conditions for other branches are not satisfied. A branch is made up of a condition, a response and a next step. See `default_branch`.
     */
    @JvmName("oawrsydmyinypjtn")
    public suspend fun defaultBranch(`value`: Output<V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgs>) {
        this.defaultBranch = value
    }

    /**
     * @param value Whether a conditional branch is active. When active is false, the conditions are not evaluated.
     */
    @JvmName("dgaiytgjvseqwfdp")
    public suspend fun active(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("riyrkpyfbajeqwtw")
    public suspend fun conditionalBranches(`value`: List<V2modelsIntentConfirmationSettingFailureConditionalConditionalBranchArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditionalBranches = mapped
    }

    /**
     * @param argument Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("kdsomoxqfehlsmxb")
    public suspend fun conditionalBranches(argument: List<suspend V2modelsIntentConfirmationSettingFailureConditionalConditionalBranchArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingFailureConditionalConditionalBranchArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditionalBranches = mapped
    }

    /**
     * @param argument Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("mhngoxarppoiynpl")
    public suspend fun conditionalBranches(vararg argument: suspend V2modelsIntentConfirmationSettingFailureConditionalConditionalBranchArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingFailureConditionalConditionalBranchArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditionalBranches = mapped
    }

    /**
     * @param argument Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("mjotcpvmafirdqtl")
    public suspend fun conditionalBranches(argument: suspend V2modelsIntentConfirmationSettingFailureConditionalConditionalBranchArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentConfirmationSettingFailureConditionalConditionalBranchArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.conditionalBranches = mapped
    }

    /**
     * @param values Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
     */
    @JvmName("iunbbridfyiveceo")
    public suspend fun conditionalBranches(vararg values: V2modelsIntentConfirmationSettingFailureConditionalConditionalBranchArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditionalBranches = mapped
    }

    /**
     * @param value Configuration block for the conditional branch that should be followed when the conditions for other branches are not satisfied. A branch is made up of a condition, a response and a next step. See `default_branch`.
     */
    @JvmName("alahgwrxrscxewvc")
    public suspend fun defaultBranch(`value`: V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultBranch = mapped
    }

    /**
     * @param argument Configuration block for the conditional branch that should be followed when the conditions for other branches are not satisfied. A branch is made up of a condition, a response and a next step. See `default_branch`.
     */
    @JvmName("ccssmxsbvkkeffwd")
    public suspend fun defaultBranch(argument: suspend V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultBranch = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingFailureConditionalArgs =
        V2modelsIntentConfirmationSettingFailureConditionalArgs(
            active = active ?: throw PulumiNullFieldException("active"),
            conditionalBranches = conditionalBranches,
            defaultBranch = defaultBranch ?: throw PulumiNullFieldException("defaultBranch"),
        )
}
