@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property nextStep Configuration block for the next step in the conversation. See `next_step`.
 * @property response Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
 */
public data class V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgs(
    public val nextStep: Output<V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchNextStepArgs>? = null,
    public val response: Output<V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchResponseArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgs.builder()
            .nextStep(nextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .response(response?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgs].
 */
@PulumiTagMarker
public class V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgsBuilder internal constructor() {
    private var nextStep:
        Output<V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchNextStepArgs>? = null

    private var response:
        Output<V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchResponseArgs>? = null

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("xkgjjtnjeorryjwb")
    public suspend fun nextStep(`value`: Output<V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchNextStepArgs>) {
        this.nextStep = value
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("gfgkmqflxsjdhswh")
    public suspend fun response(`value`: Output<V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchResponseArgs>) {
        this.response = value
    }

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("dycrejbqmbxvslwt")
    public suspend fun nextStep(`value`: V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("qvdkrrtgluatlero")
    public suspend fun nextStep(argument: suspend V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.nextStep = mapped
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("yfkodehnnrhnexkj")
    public suspend fun response(`value`: V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.response = mapped
    }

    /**
     * @param argument Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("trgdgjdbygtrgeiv")
    public suspend fun response(argument: suspend V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.response = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgs =
        V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchArgs(
            nextStep = nextStep,
            response = response,
        )
}
