@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property buttons Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
 * @property imageUrl URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
 * @property subtitle Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
 * @property title Title to display on the response card. The format of the title is determined by the platform displaying the response card.
 */
public data class
V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardArgs(
    public val buttons: Output<List<V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardButtonArgs>>? =
        null,
    public val imageUrl: Output<String>? = null,
    public val subtitle: Output<String>? = null,
    public val title: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardArgs.builder()
            .buttons(
                buttons?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .imageUrl(imageUrl?.applyValue({ args0 -> args0 }))
            .subtitle(subtitle?.applyValue({ args0 -> args0 }))
            .title(title.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardArgsBuilder
internal constructor() {
    private var buttons:
        Output<List<V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardButtonArgs>>? =
        null

    private var imageUrl: Output<String>? = null

    private var subtitle: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("fhpmdhhkidmfaqao")
    public suspend fun buttons(`value`: Output<List<V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardButtonArgs>>) {
        this.buttons = value
    }

    @JvmName("mpfokhknwiknmfsu")
    public suspend fun buttons(vararg values: Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardButtonArgs>) {
        this.buttons = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("wvmvfrppxgkvcmmo")
    public suspend fun buttons(values: List<Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardButtonArgs>>) {
        this.buttons = Output.all(values)
    }

    /**
     * @param value URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
     */
    @JvmName("cfbhqkebyeqindpo")
    public suspend fun imageUrl(`value`: Output<String>) {
        this.imageUrl = value
    }

    /**
     * @param value Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
     */
    @JvmName("davkuftlcogxqieg")
    public suspend fun subtitle(`value`: Output<String>) {
        this.subtitle = value
    }

    /**
     * @param value Title to display on the response card. The format of the title is determined by the platform displaying the response card.
     */
    @JvmName("yqehqxkkgjdlgiuc")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("jmvnmleqictdprja")
    public suspend fun buttons(`value`: List<V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardButtonArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("bqiwrrglntpygytb")
    public suspend fun buttons(argument: List<suspend V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardButtonArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardButtonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("osnvjxndstwjwpeu")
    public suspend fun buttons(vararg argument: suspend V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardButtonArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardButtonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("qbemnftixllussun")
    public suspend fun buttons(argument: suspend V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardButtonArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardButtonArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param values Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("otjfpwyfnmcjdrsl")
    public suspend fun buttons(vararg values: V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardButtonArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.buttons = mapped
    }

    /**
     * @param value URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
     */
    @JvmName("ipnyrrojxcabtjev")
    public suspend fun imageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageUrl = mapped
    }

    /**
     * @param value Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
     */
    @JvmName("dksdmqckvdrjahuu")
    public suspend fun subtitle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subtitle = mapped
    }

    /**
     * @param value Title to display on the response card. The format of the title is determined by the platform displaying the response card.
     */
    @JvmName("pabvosrgrcqetocd")
    public suspend fun title(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardArgs =
        V2modelsIntentConfirmationSettingFailureResponseMessageGroupMessageImageResponseCardArgs(
            buttons = buttons,
            imageUrl = imageUrl,
            subtitle = subtitle,
            title = title ?: throw PulumiNullFieldException("title"),
        )
}
