@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customPayload Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
 * @property imageResponseCard Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
 * @property plainTextMessage Configuration block for a message in plain text format. See `plain_text_message`.
 * @property ssmlMessage Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
 */
public data class V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationArgs(
    public val customPayload: Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationCustomPayloadArgs>? =
        null,
    public val imageResponseCard: Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationImageResponseCardArgs>? =
        null,
    public val plainTextMessage: Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationPlainTextMessageArgs>? =
        null,
    public val ssmlMessage: Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationSsmlMessageArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationArgs.builder()
            .customPayload(customPayload?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageResponseCard(imageResponseCard?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .plainTextMessage(plainTextMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ssmlMessage(ssmlMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationArgs].
 */
@PulumiTagMarker
public class V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationArgsBuilder
internal constructor() {
    private var customPayload:
        Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationCustomPayloadArgs>? =
        null

    private var imageResponseCard:
        Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationImageResponseCardArgs>? =
        null

    private var plainTextMessage:
        Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationPlainTextMessageArgs>? =
        null

    private var ssmlMessage:
        Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationSsmlMessageArgs>? =
        null

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("muiawemovuwtvbju")
    public suspend fun customPayload(`value`: Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationCustomPayloadArgs>) {
        this.customPayload = value
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("sgbvxmlivlkwgdae")
    public suspend fun imageResponseCard(`value`: Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationImageResponseCardArgs>) {
        this.imageResponseCard = value
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("qhwvgtyrmjmukyye")
    public suspend fun plainTextMessage(`value`: Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationPlainTextMessageArgs>) {
        this.plainTextMessage = value
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("quaiskbmktnkcqdt")
    public suspend fun ssmlMessage(`value`: Output<V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationSsmlMessageArgs>) {
        this.ssmlMessage = value
    }

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("pdrfmtowpvnhruif")
    public suspend fun customPayload(`value`: V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationCustomPayloadArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPayload = mapped
    }

    /**
     * @param argument Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("rwcvxwtkjprrrqib")
    public suspend fun customPayload(argument: suspend V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationCustomPayloadArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationCustomPayloadArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customPayload = mapped
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("sbaiihacdhttdncv")
    public suspend fun imageResponseCard(`value`: V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationImageResponseCardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageResponseCard = mapped
    }

    /**
     * @param argument Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("reipwhmrjnpvmxum")
    public suspend fun imageResponseCard(argument: suspend V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationImageResponseCardArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationImageResponseCardArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.imageResponseCard = mapped
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("lurrvxpakunkxvha")
    public suspend fun plainTextMessage(`value`: V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationPlainTextMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plainTextMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("fcpulyxiejqiamyb")
    public suspend fun plainTextMessage(argument: suspend V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationPlainTextMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationPlainTextMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.plainTextMessage = mapped
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("wynrnqtwerbpmmql")
    public suspend fun ssmlMessage(`value`: V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationSsmlMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssmlMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("ufqjbbhiuonafemi")
    public suspend fun ssmlMessage(argument: suspend V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationSsmlMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationSsmlMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ssmlMessage = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationArgs =
        V2modelsIntentConfirmationSettingFailureResponseMessageGroupVariationArgs(
            customPayload = customPayload,
            imageResponseCard = imageResponseCard,
            plainTextMessage = plainTextMessage,
            ssmlMessage = ssmlMessage,
        )
}
