@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowInterrupt Whether the user can interrupt a speech prompt from the bot.
 * @property maxRetries Maximum number of times the bot tries to elicit a response from the user using this prompt.
 * @property messageGroups Configuration block for messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime. See `message_group`.
 * @property messageSelectionStrategy How a message is selected from a message group among retries. Valid values are `Random` and `Ordered`.
 * @property promptAttemptsSpecifications Configuration block for advanced settings on each attempt of the prompt. See `prompt_attempts_specification`.
 */
public data class V2modelsIntentConfirmationSettingPromptSpecificationArgs(
    public val allowInterrupt: Output<Boolean>? = null,
    public val maxRetries: Output<Int>,
    public val messageGroups: Output<List<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs>>? = null,
    public val messageSelectionStrategy: Output<String>? = null,
    public val promptAttemptsSpecifications: Output<List<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationArgs.builder()
            .allowInterrupt(allowInterrupt?.applyValue({ args0 -> args0 }))
            .maxRetries(maxRetries.applyValue({ args0 -> args0 }))
            .messageGroups(
                messageGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .messageSelectionStrategy(messageSelectionStrategy?.applyValue({ args0 -> args0 }))
            .promptAttemptsSpecifications(
                promptAttemptsSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingPromptSpecificationArgs].
 */
@PulumiTagMarker
public class V2modelsIntentConfirmationSettingPromptSpecificationArgsBuilder internal constructor() {
    private var allowInterrupt: Output<Boolean>? = null

    private var maxRetries: Output<Int>? = null

    private var messageGroups:
        Output<List<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs>>? = null

    private var messageSelectionStrategy: Output<String>? = null

    private var promptAttemptsSpecifications:
        Output<List<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs>>? =
        null

    /**
     * @param value Whether the user can interrupt a speech prompt from the bot.
     */
    @JvmName("nlggpwnxutuofrit")
    public suspend fun allowInterrupt(`value`: Output<Boolean>) {
        this.allowInterrupt = value
    }

    /**
     * @param value Maximum number of times the bot tries to elicit a response from the user using this prompt.
     */
    @JvmName("ukaduiimlpqmwbjp")
    public suspend fun maxRetries(`value`: Output<Int>) {
        this.maxRetries = value
    }

    /**
     * @param value Configuration block for messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime. See `message_group`.
     */
    @JvmName("yaaklaibsjnirawr")
    public suspend fun messageGroups(`value`: Output<List<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs>>) {
        this.messageGroups = value
    }

    @JvmName("rmvahpjuyeeitnmt")
    public suspend fun messageGroups(vararg values: Output<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs>) {
        this.messageGroups = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime. See `message_group`.
     */
    @JvmName("ahhoyrjocwkjhjrc")
    public suspend fun messageGroups(values: List<Output<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs>>) {
        this.messageGroups = Output.all(values)
    }

    /**
     * @param value How a message is selected from a message group among retries. Valid values are `Random` and `Ordered`.
     */
    @JvmName("bygyycfivmhxnuxl")
    public suspend fun messageSelectionStrategy(`value`: Output<String>) {
        this.messageSelectionStrategy = value
    }

    /**
     * @param value Configuration block for advanced settings on each attempt of the prompt. See `prompt_attempts_specification`.
     */
    @JvmName("bovigebatbnglhmd")
    public suspend fun promptAttemptsSpecifications(`value`: Output<List<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs>>) {
        this.promptAttemptsSpecifications = value
    }

    @JvmName("mnsiytcnfvejvjub")
    public suspend fun promptAttemptsSpecifications(vararg values: Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs>) {
        this.promptAttemptsSpecifications = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for advanced settings on each attempt of the prompt. See `prompt_attempts_specification`.
     */
    @JvmName("inxykkfowbadyyan")
    public suspend fun promptAttemptsSpecifications(values: List<Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs>>) {
        this.promptAttemptsSpecifications = Output.all(values)
    }

    /**
     * @param value Whether the user can interrupt a speech prompt from the bot.
     */
    @JvmName("lrrcmrbupqfxgieb")
    public suspend fun allowInterrupt(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowInterrupt = mapped
    }

    /**
     * @param value Maximum number of times the bot tries to elicit a response from the user using this prompt.
     */
    @JvmName("qtuadjpogfqpmplk")
    public suspend fun maxRetries(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxRetries = mapped
    }

    /**
     * @param value Configuration block for messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime. See `message_group`.
     */
    @JvmName("diiavqfqgoxunfcj")
    public suspend fun messageGroups(`value`: List<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageGroups = mapped
    }

    /**
     * @param argument Configuration block for messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime. See `message_group`.
     */
    @JvmName("ihfpjwgogksmjqvp")
    public suspend fun messageGroups(argument: List<suspend V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param argument Configuration block for messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime. See `message_group`.
     */
    @JvmName("ndugtqbasipcbnoe")
    public suspend fun messageGroups(vararg argument: suspend V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param argument Configuration block for messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime. See `message_group`.
     */
    @JvmName("yqrociojhhhvoqxf")
    public suspend fun messageGroups(argument: suspend V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param values Configuration block for messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime. See `message_group`.
     */
    @JvmName("fyrvwlnsgqxbxefg")
    public suspend fun messageGroups(vararg values: V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageGroups = mapped
    }

    /**
     * @param value How a message is selected from a message group among retries. Valid values are `Random` and `Ordered`.
     */
    @JvmName("aqsmujoxrnqxfhik")
    public suspend fun messageSelectionStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageSelectionStrategy = mapped
    }

    /**
     * @param value Configuration block for advanced settings on each attempt of the prompt. See `prompt_attempts_specification`.
     */
    @JvmName("xjspxxxaaieigrfo")
    public suspend fun promptAttemptsSpecifications(`value`: List<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promptAttemptsSpecifications = mapped
    }

    /**
     * @param argument Configuration block for advanced settings on each attempt of the prompt. See `prompt_attempts_specification`.
     */
    @JvmName("nkmuaiiaiohwrcyr")
    public suspend fun promptAttemptsSpecifications(argument: List<suspend V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.promptAttemptsSpecifications = mapped
    }

    /**
     * @param argument Configuration block for advanced settings on each attempt of the prompt. See `prompt_attempts_specification`.
     */
    @JvmName("lansmmqnvmeeiugq")
    public suspend fun promptAttemptsSpecifications(vararg argument: suspend V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.promptAttemptsSpecifications = mapped
    }

    /**
     * @param argument Configuration block for advanced settings on each attempt of the prompt. See `prompt_attempts_specification`.
     */
    @JvmName("gtxuqmpyrwrodtwe")
    public suspend fun promptAttemptsSpecifications(argument: suspend V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.promptAttemptsSpecifications = mapped
    }

    /**
     * @param values Configuration block for advanced settings on each attempt of the prompt. See `prompt_attempts_specification`.
     */
    @JvmName("xlxcqxyqsvmahcsv")
    public suspend fun promptAttemptsSpecifications(vararg values: V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.promptAttemptsSpecifications = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingPromptSpecificationArgs =
        V2modelsIntentConfirmationSettingPromptSpecificationArgs(
            allowInterrupt = allowInterrupt,
            maxRetries = maxRetries ?: throw PulumiNullFieldException("maxRetries"),
            messageGroups = messageGroups,
            messageSelectionStrategy = messageSelectionStrategy,
            promptAttemptsSpecifications = promptAttemptsSpecifications,
        )
}
