@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property message Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
 * @property variations Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
 */
public data class V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs(
    public val message: Output<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupMessageArgs>,
    public val variations: Output<List<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupVariationArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs.builder()
            .message(message.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .variations(
                variations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs].
 */
@PulumiTagMarker
public class V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgsBuilder internal constructor() {
    private var message:
        Output<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupMessageArgs>? = null

    private var variations:
        Output<List<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupVariationArgs>>? =
        null

    /**
     * @param value Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("dycyjdylkorrxbvo")
    public suspend fun message(`value`: Output<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupMessageArgs>) {
        this.message = value
    }

    /**
     * @param value Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("peuphkydhcawmdxh")
    public suspend fun variations(`value`: Output<List<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupVariationArgs>>) {
        this.variations = value
    }

    @JvmName("wjpyqqbuewnkkari")
    public suspend fun variations(vararg values: Output<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupVariationArgs>) {
        this.variations = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("itxfwhntgyffagsw")
    public suspend fun variations(values: List<Output<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupVariationArgs>>) {
        this.variations = Output.all(values)
    }

    /**
     * @param value Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("rfvpbhyfvcbsoiin")
    public suspend fun message(`value`: V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupMessageArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param argument Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("wmftdrkvlbomhgjo")
    public suspend fun message(argument: suspend V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.message = mapped
    }

    /**
     * @param value Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("hwvjccouyelufcob")
    public suspend fun variations(`value`: List<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupVariationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("hwedwrfekkaguemh")
    public suspend fun variations(argument: List<suspend V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupVariationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("dpdhjyfkgnlvxcvr")
    public suspend fun variations(vararg argument: suspend V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupVariationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("darijaqqrccgpxlg")
    public suspend fun variations(argument: suspend V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupVariationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupVariationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param values Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("fkbwaivbafhxkuro")
    public suspend fun variations(vararg values: V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupVariationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs =
        V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupArgs(
            message = message ?: throw PulumiNullFieldException("message"),
            variations = variations,
        )
}
