@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property allowInterrupt Whether the user can interrupt a speech prompt attempt from the bot.
 * @property allowedInputTypes Configuration block for the allowed input types of the prompt attempt. See `allowed_input_types`.
 * @property audioAndDtmfInputSpecification Configuration block for settings on audio and DTMF input. See `audio_and_dtmf_input_specification`.
 * @property mapBlockKey Which attempt to configure. Valid values are `Initial`, `Retry1`, `Retry2`, `Retry3`, `Retry4`, `Retry5`.
 * @property textInputSpecification Configuration block for the settings on text input. See `text_input_specification`.
 */
public data class
V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs(
    public val allowInterrupt: Output<Boolean>? = null,
    public val allowedInputTypes: Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAllowedInputTypesArgs>,
    public val audioAndDtmfInputSpecification: Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgs>? =
        null,
    public val mapBlockKey: Output<String>,
    public val textInputSpecification: Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationTextInputSpecificationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs.builder()
            .allowInterrupt(allowInterrupt?.applyValue({ args0 -> args0 }))
            .allowedInputTypes(allowedInputTypes.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .audioAndDtmfInputSpecification(
                audioAndDtmfInputSpecification?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .mapBlockKey(mapBlockKey.applyValue({ args0 -> args0 }))
            .textInputSpecification(
                textInputSpecification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgsBuilder
internal constructor() {
    private var allowInterrupt: Output<Boolean>? = null

    private var allowedInputTypes:
        Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAllowedInputTypesArgs>? =
        null

    private var audioAndDtmfInputSpecification:
        Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgs>? =
        null

    private var mapBlockKey: Output<String>? = null

    private var textInputSpecification:
        Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationTextInputSpecificationArgs>? =
        null

    /**
     * @param value Whether the user can interrupt a speech prompt attempt from the bot.
     */
    @JvmName("dybkmitrojybgxim")
    public suspend fun allowInterrupt(`value`: Output<Boolean>) {
        this.allowInterrupt = value
    }

    /**
     * @param value Configuration block for the allowed input types of the prompt attempt. See `allowed_input_types`.
     */
    @JvmName("tkmmwphlfybtmkrn")
    public suspend fun allowedInputTypes(`value`: Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAllowedInputTypesArgs>) {
        this.allowedInputTypes = value
    }

    /**
     * @param value Configuration block for settings on audio and DTMF input. See `audio_and_dtmf_input_specification`.
     */
    @JvmName("fvgldioxrieirgcv")
    public suspend fun audioAndDtmfInputSpecification(`value`: Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgs>) {
        this.audioAndDtmfInputSpecification = value
    }

    /**
     * @param value Which attempt to configure. Valid values are `Initial`, `Retry1`, `Retry2`, `Retry3`, `Retry4`, `Retry5`.
     */
    @JvmName("miwuxhflcxblvdrl")
    public suspend fun mapBlockKey(`value`: Output<String>) {
        this.mapBlockKey = value
    }

    /**
     * @param value Configuration block for the settings on text input. See `text_input_specification`.
     */
    @JvmName("ajujsrniwbbcinbl")
    public suspend fun textInputSpecification(`value`: Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationTextInputSpecificationArgs>) {
        this.textInputSpecification = value
    }

    /**
     * @param value Whether the user can interrupt a speech prompt attempt from the bot.
     */
    @JvmName("psfciikwyagfsrqd")
    public suspend fun allowInterrupt(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowInterrupt = mapped
    }

    /**
     * @param value Configuration block for the allowed input types of the prompt attempt. See `allowed_input_types`.
     */
    @JvmName("fjayuimrjykaaxcm")
    public suspend fun allowedInputTypes(`value`: V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAllowedInputTypesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedInputTypes = mapped
    }

    /**
     * @param argument Configuration block for the allowed input types of the prompt attempt. See `allowed_input_types`.
     */
    @JvmName("slwefkmbsyvmakkb")
    public suspend fun allowedInputTypes(argument: suspend V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAllowedInputTypesArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAllowedInputTypesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allowedInputTypes = mapped
    }

    /**
     * @param value Configuration block for settings on audio and DTMF input. See `audio_and_dtmf_input_specification`.
     */
    @JvmName("mwnihfxggaggvari")
    public suspend fun audioAndDtmfInputSpecification(`value`: V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioAndDtmfInputSpecification = mapped
    }

    /**
     * @param argument Configuration block for settings on audio and DTMF input. See `audio_and_dtmf_input_specification`.
     */
    @JvmName("iocxryaqlvcefkjp")
    public suspend fun audioAndDtmfInputSpecification(argument: suspend V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.audioAndDtmfInputSpecification = mapped
    }

    /**
     * @param value Which attempt to configure. Valid values are `Initial`, `Retry1`, `Retry2`, `Retry3`, `Retry4`, `Retry5`.
     */
    @JvmName("fgbtmcgjojrgvhxc")
    public suspend fun mapBlockKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mapBlockKey = mapped
    }

    /**
     * @param value Configuration block for the settings on text input. See `text_input_specification`.
     */
    @JvmName("clmuaawogmajxxin")
    public suspend fun textInputSpecification(`value`: V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationTextInputSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.textInputSpecification = mapped
    }

    /**
     * @param argument Configuration block for the settings on text input. See `text_input_specification`.
     */
    @JvmName("rspgtgoopqqcyfjm")
    public suspend fun textInputSpecification(argument: suspend V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationTextInputSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationTextInputSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.textInputSpecification = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs =
        V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationArgs(
            allowInterrupt = allowInterrupt,
            allowedInputTypes = allowedInputTypes ?: throw PulumiNullFieldException("allowedInputTypes"),
            audioAndDtmfInputSpecification = audioAndDtmfInputSpecification,
            mapBlockKey = mapBlockKey ?: throw PulumiNullFieldException("mapBlockKey"),
            textInputSpecification = textInputSpecification,
        )
}
