@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property audioSpecification Configuration block for the settings on audio input. See `audio_specification`.
 * @property dtmfSpecification Configuration block for the settings on DTMF input. See `dtmf_specification`.
 * @property startTimeoutMs Time for which a bot waits before assuming that the customer isn't going to speak or press a key. This timeout is shared between Audio and DTMF inputs.
 */
public data class
V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgs(
    public val audioSpecification: Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgs>? =
        null,
    public val dtmfSpecification: Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgs>? =
        null,
    public val startTimeoutMs: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgs.builder()
            .audioSpecification(
                audioSpecification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dtmfSpecification(dtmfSpecification?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startTimeoutMs(startTimeoutMs.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgsBuilder
internal constructor() {
    private var audioSpecification:
        Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgs>? =
        null

    private var dtmfSpecification:
        Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgs>? =
        null

    private var startTimeoutMs: Output<Int>? = null

    /**
     * @param value Configuration block for the settings on audio input. See `audio_specification`.
     */
    @JvmName("fyrayoelnrymmwgb")
    public suspend fun audioSpecification(`value`: Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgs>) {
        this.audioSpecification = value
    }

    /**
     * @param value Configuration block for the settings on DTMF input. See `dtmf_specification`.
     */
    @JvmName("stphnisfjovqihvs")
    public suspend fun dtmfSpecification(`value`: Output<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgs>) {
        this.dtmfSpecification = value
    }

    /**
     * @param value Time for which a bot waits before assuming that the customer isn't going to speak or press a key. This timeout is shared between Audio and DTMF inputs.
     */
    @JvmName("nlqbdyberavkqdya")
    public suspend fun startTimeoutMs(`value`: Output<Int>) {
        this.startTimeoutMs = value
    }

    /**
     * @param value Configuration block for the settings on audio input. See `audio_specification`.
     */
    @JvmName("dksglvjljcfcvyii")
    public suspend fun audioSpecification(`value`: V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioSpecification = mapped
    }

    /**
     * @param argument Configuration block for the settings on audio input. See `audio_specification`.
     */
    @JvmName("cbqiomekhlpjvyjh")
    public suspend fun audioSpecification(argument: suspend V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.audioSpecification = mapped
    }

    /**
     * @param value Configuration block for the settings on DTMF input. See `dtmf_specification`.
     */
    @JvmName("xpanqdvcawngksyy")
    public suspend fun dtmfSpecification(`value`: V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dtmfSpecification = mapped
    }

    /**
     * @param argument Configuration block for the settings on DTMF input. See `dtmf_specification`.
     */
    @JvmName("nqxwcytawetcvlef")
    public suspend fun dtmfSpecification(argument: suspend V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dtmfSpecification = mapped
    }

    /**
     * @param value Time for which a bot waits before assuming that the customer isn't going to speak or press a key. This timeout is shared between Audio and DTMF inputs.
     */
    @JvmName("kraxfilcwralphck")
    public suspend fun startTimeoutMs(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startTimeoutMs = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgs =
        V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationArgs(
            audioSpecification = audioSpecification,
            dtmfSpecification = dtmfSpecification,
            startTimeoutMs = startTimeoutMs ?: throw PulumiNullFieldException("startTimeoutMs"),
        )
}
