@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endTimeoutMs Time for which a bot waits after the customer stops speaking to assume the utterance is finished.
 * @property maxLengthMs Time for how long Amazon Lex waits before speech input is truncated and the speech is returned to application.
 */
public data class
V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgs(
    public val endTimeoutMs: Output<Int>,
    public val maxLengthMs: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgs.builder()
            .endTimeoutMs(endTimeoutMs.applyValue({ args0 -> args0 }))
            .maxLengthMs(maxLengthMs.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgsBuilder
internal constructor() {
    private var endTimeoutMs: Output<Int>? = null

    private var maxLengthMs: Output<Int>? = null

    /**
     * @param value Time for which a bot waits after the customer stops speaking to assume the utterance is finished.
     */
    @JvmName("akqyweiojysclwou")
    public suspend fun endTimeoutMs(`value`: Output<Int>) {
        this.endTimeoutMs = value
    }

    /**
     * @param value Time for how long Amazon Lex waits before speech input is truncated and the speech is returned to application.
     */
    @JvmName("rcjbuydogkluinwc")
    public suspend fun maxLengthMs(`value`: Output<Int>) {
        this.maxLengthMs = value
    }

    /**
     * @param value Time for which a bot waits after the customer stops speaking to assume the utterance is finished.
     */
    @JvmName("txonmkrjvejjcouk")
    public suspend fun endTimeoutMs(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endTimeoutMs = mapped
    }

    /**
     * @param value Time for how long Amazon Lex waits before speech input is truncated and the speech is returned to application.
     */
    @JvmName("lukjyvhawubdppyn")
    public suspend fun maxLengthMs(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxLengthMs = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgs =
        V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationAudioSpecificationArgs(
            endTimeoutMs = endTimeoutMs ?: throw PulumiNullFieldException("endTimeoutMs"),
            maxLengthMs = maxLengthMs ?: throw PulumiNullFieldException("maxLengthMs"),
        )
}
