@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deletionCharacter DTMF character that clears the accumulated DTMF digits and immediately ends the input.
 * @property endCharacter DTMF character that immediately ends input. If the user does not press this character, the input ends after the end timeout.
 * @property endTimeoutMs How long the bot should wait after the last DTMF character input before assuming that the input has concluded.
 * @property maxLength Maximum number of DTMF digits allowed in an utterance.
 */
public data class
V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgs(
    public val deletionCharacter: Output<String>,
    public val endCharacter: Output<String>,
    public val endTimeoutMs: Output<Int>,
    public val maxLength: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgs.builder()
            .deletionCharacter(deletionCharacter.applyValue({ args0 -> args0 }))
            .endCharacter(endCharacter.applyValue({ args0 -> args0 }))
            .endTimeoutMs(endTimeoutMs.applyValue({ args0 -> args0 }))
            .maxLength(maxLength.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgsBuilder
internal constructor() {
    private var deletionCharacter: Output<String>? = null

    private var endCharacter: Output<String>? = null

    private var endTimeoutMs: Output<Int>? = null

    private var maxLength: Output<Int>? = null

    /**
     * @param value DTMF character that clears the accumulated DTMF digits and immediately ends the input.
     */
    @JvmName("tdmfnkbbnknmqsde")
    public suspend fun deletionCharacter(`value`: Output<String>) {
        this.deletionCharacter = value
    }

    /**
     * @param value DTMF character that immediately ends input. If the user does not press this character, the input ends after the end timeout.
     */
    @JvmName("myglydfoolysvilo")
    public suspend fun endCharacter(`value`: Output<String>) {
        this.endCharacter = value
    }

    /**
     * @param value How long the bot should wait after the last DTMF character input before assuming that the input has concluded.
     */
    @JvmName("gpikmtksvytsjafy")
    public suspend fun endTimeoutMs(`value`: Output<Int>) {
        this.endTimeoutMs = value
    }

    /**
     * @param value Maximum number of DTMF digits allowed in an utterance.
     */
    @JvmName("nchkfeaowacglckf")
    public suspend fun maxLength(`value`: Output<Int>) {
        this.maxLength = value
    }

    /**
     * @param value DTMF character that clears the accumulated DTMF digits and immediately ends the input.
     */
    @JvmName("vgjhgwfmhvuwslfe")
    public suspend fun deletionCharacter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deletionCharacter = mapped
    }

    /**
     * @param value DTMF character that immediately ends input. If the user does not press this character, the input ends after the end timeout.
     */
    @JvmName("kuietjircpaypfub")
    public suspend fun endCharacter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endCharacter = mapped
    }

    /**
     * @param value How long the bot should wait after the last DTMF character input before assuming that the input has concluded.
     */
    @JvmName("rthmbovxrwurcxgi")
    public suspend fun endTimeoutMs(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endTimeoutMs = mapped
    }

    /**
     * @param value Maximum number of DTMF digits allowed in an utterance.
     */
    @JvmName("okmdkxrjcjqnilnh")
    public suspend fun maxLength(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxLength = mapped
    }

    internal fun build(): V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgs =
        V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecificationArgs(
            deletionCharacter = deletionCharacter ?: throw PulumiNullFieldException("deletionCharacter"),
            endCharacter = endCharacter ?: throw PulumiNullFieldException("endCharacter"),
            endTimeoutMs = endTimeoutMs ?: throw PulumiNullFieldException("endTimeoutMs"),
            maxLength = maxLength ?: throw PulumiNullFieldException("maxLength"),
        )
}
