@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentDialogCodeHookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables the dialog code hook so that it processes user requests.
 */
public data class V2modelsIntentDialogCodeHookArgs(
    public val enabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentDialogCodeHookArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentDialogCodeHookArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentDialogCodeHookArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentDialogCodeHookArgs].
 */
@PulumiTagMarker
public class V2modelsIntentDialogCodeHookArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Enables the dialog code hook so that it processes user requests.
     */
    @JvmName("npmehexrjfhmokpp")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Enables the dialog code hook so that it processes user requests.
     */
    @JvmName("wftquxovyvbhgisd")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): V2modelsIntentDialogCodeHookArgs = V2modelsIntentDialogCodeHookArgs(
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
    )
}
