@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property active Whether the fulfillment code hook is used. When active is false, the code hook doesn't run.
 * @property enabled Whether a Lambda function should be invoked to fulfill a specific intent.
 * @property fulfillmentUpdatesSpecification Configuration block for settings for update messages sent to the user for long-running Lambda fulfillment functions. Fulfillment updates can be used only with streaming conversations. See `fulfillment_updates_specification`.
 * @property postFulfillmentStatusSpecification Configuration block for settings for messages sent to the user for after the Lambda fulfillment function completes. Post-fulfillment messages can be sent for both streaming and non-streaming conversations. See `post_fulfillment_status_specification`.
 */
public data class V2modelsIntentFulfillmentCodeHookArgs(
    public val active: Output<Boolean>? = null,
    public val enabled: Output<Boolean>,
    public val fulfillmentUpdatesSpecification: Output<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgs>? = null,
    public val postFulfillmentStatusSpecification: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookArgs.builder()
            .active(active?.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .fulfillmentUpdatesSpecification(
                fulfillmentUpdatesSpecification?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .postFulfillmentStatusSpecification(
                postFulfillmentStatusSpecification?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentFulfillmentCodeHookArgs].
 */
@PulumiTagMarker
public class V2modelsIntentFulfillmentCodeHookArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var enabled: Output<Boolean>? = null

    private var fulfillmentUpdatesSpecification:
        Output<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgs>? = null

    private var postFulfillmentStatusSpecification:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgs>? = null

    /**
     * @param value Whether the fulfillment code hook is used. When active is false, the code hook doesn't run.
     */
    @JvmName("brusygwbamxbfvtq")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Whether a Lambda function should be invoked to fulfill a specific intent.
     */
    @JvmName("sjkccnxcfjtqkhmu")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Configuration block for settings for update messages sent to the user for long-running Lambda fulfillment functions. Fulfillment updates can be used only with streaming conversations. See `fulfillment_updates_specification`.
     */
    @JvmName("uvbhnxsxqmvkxhgu")
    public suspend fun fulfillmentUpdatesSpecification(`value`: Output<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgs>) {
        this.fulfillmentUpdatesSpecification = value
    }

    /**
     * @param value Configuration block for settings for messages sent to the user for after the Lambda fulfillment function completes. Post-fulfillment messages can be sent for both streaming and non-streaming conversations. See `post_fulfillment_status_specification`.
     */
    @JvmName("qoxfkwrmhvvpickh")
    public suspend fun postFulfillmentStatusSpecification(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgs>) {
        this.postFulfillmentStatusSpecification = value
    }

    /**
     * @param value Whether the fulfillment code hook is used. When active is false, the code hook doesn't run.
     */
    @JvmName("poxwpydejcrbcghh")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Whether a Lambda function should be invoked to fulfill a specific intent.
     */
    @JvmName("givudddxchjutwfl")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Configuration block for settings for update messages sent to the user for long-running Lambda fulfillment functions. Fulfillment updates can be used only with streaming conversations. See `fulfillment_updates_specification`.
     */
    @JvmName("dcgipckdlowiwlmj")
    public suspend fun fulfillmentUpdatesSpecification(`value`: V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fulfillmentUpdatesSpecification = mapped
    }

    /**
     * @param argument Configuration block for settings for update messages sent to the user for long-running Lambda fulfillment functions. Fulfillment updates can be used only with streaming conversations. See `fulfillment_updates_specification`.
     */
    @JvmName("gvkdgnejqbwqlgsk")
    public suspend fun fulfillmentUpdatesSpecification(argument: suspend V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fulfillmentUpdatesSpecification = mapped
    }

    /**
     * @param value Configuration block for settings for messages sent to the user for after the Lambda fulfillment function completes. Post-fulfillment messages can be sent for both streaming and non-streaming conversations. See `post_fulfillment_status_specification`.
     */
    @JvmName("yhsgjkcwexvcacnm")
    public suspend fun postFulfillmentStatusSpecification(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postFulfillmentStatusSpecification = mapped
    }

    /**
     * @param argument Configuration block for settings for messages sent to the user for after the Lambda fulfillment function completes. Post-fulfillment messages can be sent for both streaming and non-streaming conversations. See `post_fulfillment_status_specification`.
     */
    @JvmName("ywkevqdvrlbpgrpo")
    public suspend fun postFulfillmentStatusSpecification(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.postFulfillmentStatusSpecification = mapped
    }

    internal fun build(): V2modelsIntentFulfillmentCodeHookArgs =
        V2modelsIntentFulfillmentCodeHookArgs(
            active = active,
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            fulfillmentUpdatesSpecification = fulfillmentUpdatesSpecification,
            postFulfillmentStatusSpecification = postFulfillmentStatusSpecification,
        )
}
