@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property active Whether fulfillment updates are sent to the user. When this field is true, updates are sent. If the active field is set to true, the `start_response`, `update_response`, and `timeout_in_seconds` fields are required.
 * @property startResponse Configuration block for the message sent to users when the fulfillment Lambda functions starts running.
 * @property timeoutInSeconds Length of time that the fulfillment Lambda function should run before it times out.
 * @property updateResponse Configuration block for messages sent periodically to the user while the fulfillment Lambda function is running.
 */
public data class V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgs(
    public val active: Output<Boolean>,
    public val startResponse: Output<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgs>? =
        null,
    public val timeoutInSeconds: Output<Int>? = null,
    public val updateResponse: Output<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponseArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgs.builder()
            .active(active.applyValue({ args0 -> args0 }))
            .startResponse(startResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 }))
            .updateResponse(
                updateResponse?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgs].
 */
@PulumiTagMarker
public class V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var startResponse:
        Output<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgs>? =
        null

    private var timeoutInSeconds: Output<Int>? = null

    private var updateResponse:
        Output<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponseArgs>? =
        null

    /**
     * @param value Whether fulfillment updates are sent to the user. When this field is true, updates are sent. If the active field is set to true, the `start_response`, `update_response`, and `timeout_in_seconds` fields are required.
     */
    @JvmName("prehfxkwefspcqdb")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Configuration block for the message sent to users when the fulfillment Lambda functions starts running.
     */
    @JvmName("cegmtesivtsyjwcs")
    public suspend fun startResponse(`value`: Output<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgs>) {
        this.startResponse = value
    }

    /**
     * @param value Length of time that the fulfillment Lambda function should run before it times out.
     */
    @JvmName("uuojmqepfmvyuixj")
    public suspend fun timeoutInSeconds(`value`: Output<Int>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value Configuration block for messages sent periodically to the user while the fulfillment Lambda function is running.
     */
    @JvmName("dqivdagfidvautvm")
    public suspend fun updateResponse(`value`: Output<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponseArgs>) {
        this.updateResponse = value
    }

    /**
     * @param value Whether fulfillment updates are sent to the user. When this field is true, updates are sent. If the active field is set to true, the `start_response`, `update_response`, and `timeout_in_seconds` fields are required.
     */
    @JvmName("kmypvlmqvumykpqd")
    public suspend fun active(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Configuration block for the message sent to users when the fulfillment Lambda functions starts running.
     */
    @JvmName("qqmbqertwrdjgfpj")
    public suspend fun startResponse(`value`: V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startResponse = mapped
    }

    /**
     * @param argument Configuration block for the message sent to users when the fulfillment Lambda functions starts running.
     */
    @JvmName("jgiaxvuxbpciqkuw")
    public suspend fun startResponse(argument: suspend V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.startResponse = mapped
    }

    /**
     * @param value Length of time that the fulfillment Lambda function should run before it times out.
     */
    @JvmName("qrgbqekcecfrcvuv")
    public suspend fun timeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    /**
     * @param value Configuration block for messages sent periodically to the user while the fulfillment Lambda function is running.
     */
    @JvmName("bktfemhikoyylslv")
    public suspend fun updateResponse(`value`: V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateResponse = mapped
    }

    /**
     * @param argument Configuration block for messages sent periodically to the user while the fulfillment Lambda function is running.
     */
    @JvmName("pslxjnmmrneoehat")
    public suspend fun updateResponse(argument: suspend V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.updateResponse = mapped
    }

    internal fun build(): V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgs =
        V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationArgs(
            active = active ?: throw PulumiNullFieldException("active"),
            startResponse = startResponse,
            timeoutInSeconds = timeoutInSeconds,
            updateResponse = updateResponse,
        )
}
