@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowInterrupt Whether the user can interrupt the start message while it is playing.
 * @property delayInSeconds Delay between when the Lambda fulfillment function starts running and the start message is played. If the Lambda function returns before the delay is over, the start message isn't played.
 * @property messageGroups Between 1-5 configuration block message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user. See `message_group`.
 */
public data class V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgs(
    public val allowInterrupt: Output<Boolean>? = null,
    public val delayInSeconds: Output<Int>? = null,
    public val messageGroups: Output<List<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroupArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgs.builder()
            .allowInterrupt(allowInterrupt?.applyValue({ args0 -> args0 }))
            .delayInSeconds(delayInSeconds?.applyValue({ args0 -> args0 }))
            .messageGroups(
                messageGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgsBuilder
internal constructor() {
    private var allowInterrupt: Output<Boolean>? = null

    private var delayInSeconds: Output<Int>? = null

    private var messageGroups:
        Output<List<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroupArgs>>? =
        null

    /**
     * @param value Whether the user can interrupt the start message while it is playing.
     */
    @JvmName("ydcadgmcgtyndugy")
    public suspend fun allowInterrupt(`value`: Output<Boolean>) {
        this.allowInterrupt = value
    }

    /**
     * @param value Delay between when the Lambda fulfillment function starts running and the start message is played. If the Lambda function returns before the delay is over, the start message isn't played.
     */
    @JvmName("bmwpacdrfsawtkdt")
    public suspend fun delayInSeconds(`value`: Output<Int>) {
        this.delayInSeconds = value
    }

    /**
     * @param value Between 1-5 configuration block message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user. See `message_group`.
     */
    @JvmName("fhmgbcfhunnbrlqt")
    public suspend fun messageGroups(`value`: Output<List<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroupArgs>>) {
        this.messageGroups = value
    }

    @JvmName("ojrdefskwchixaka")
    public suspend fun messageGroups(vararg values: Output<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroupArgs>) {
        this.messageGroups = Output.all(values.asList())
    }

    /**
     * @param values Between 1-5 configuration block message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user. See `message_group`.
     */
    @JvmName("vdguhcroodlfqblg")
    public suspend fun messageGroups(values: List<Output<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroupArgs>>) {
        this.messageGroups = Output.all(values)
    }

    /**
     * @param value Whether the user can interrupt the start message while it is playing.
     */
    @JvmName("ojleonwcvrenxije")
    public suspend fun allowInterrupt(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowInterrupt = mapped
    }

    /**
     * @param value Delay between when the Lambda fulfillment function starts running and the start message is played. If the Lambda function returns before the delay is over, the start message isn't played.
     */
    @JvmName("vhjmvtyxnjibhhuf")
    public suspend fun delayInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delayInSeconds = mapped
    }

    /**
     * @param value Between 1-5 configuration block message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user. See `message_group`.
     */
    @JvmName("hjrxqmexiomofjbl")
    public suspend fun messageGroups(`value`: List<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageGroups = mapped
    }

    /**
     * @param argument Between 1-5 configuration block message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user. See `message_group`.
     */
    @JvmName("mewucukqkeqknkwc")
    public suspend fun messageGroups(argument: List<suspend V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param argument Between 1-5 configuration block message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user. See `message_group`.
     */
    @JvmName("kbmxcnlqlvdielhu")
    public suspend fun messageGroups(vararg argument: suspend V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param argument Between 1-5 configuration block message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user. See `message_group`.
     */
    @JvmName("jrcdfnfcqyuokmuo")
    public suspend fun messageGroups(argument: suspend V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroupArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroupArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param values Between 1-5 configuration block message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user. See `message_group`.
     */
    @JvmName("tasegyrplbxelsrt")
    public suspend fun messageGroups(vararg values: V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageGroups = mapped
    }

    internal fun build(): V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgs =
        V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseArgs(
            allowInterrupt = allowInterrupt,
            delayInSeconds = delayInSeconds,
            messageGroups = messageGroups,
        )
}
