@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property failureConditional Configuration block for conditional branches to evaluate after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed. See `failure_conditional`.
 * @property failureNextStep Configuration block for the next step the bot runs after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed. See `failure_next_step`.
 * @property failureResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
 * @property successConditional Configuration block for conditional branches to evaluate after the dialog code hook finishes successfully. See `success_conditional`.
 * @property successNextStep Configuration block for the next step the bot runs after the dialog code hook finishes successfully. See `success_next_step`.
 * @property successResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `success_response`.
 * @property timeoutConditional Configuration block for conditional branches to evaluate if the code hook times out. See `timeout_conditional`.
 * @property timeoutNextStep Configuration block for the next step that the bot runs when the code hook times out. See `timeout_next_step`.
 * @property timeoutResponse Configuration block for a list of message groups that Amazon Lex uses to respond the user input. See `timeout_response`.
 */
public data class V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgs(
    public val failureConditional: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalArgs>? =
        null,
    public val failureNextStep: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureNextStepArgs>? =
        null,
    public val failureResponse: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureResponseArgs>? =
        null,
    public val successConditional: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditionalArgs>? =
        null,
    public val successNextStep: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgs>? =
        null,
    public val successResponse: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessResponseArgs>? =
        null,
    public val timeoutConditional: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalArgs>? =
        null,
    public val timeoutNextStep: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgs>? =
        null,
    public val timeoutResponse: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutResponseArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgs.builder()
            .failureConditional(
                failureConditional?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .failureNextStep(failureNextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .failureResponse(failureResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .successConditional(
                successConditional?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .successNextStep(successNextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .successResponse(successResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeoutConditional(
                timeoutConditional?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .timeoutNextStep(timeoutNextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeoutResponse(
                timeoutResponse?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgs].
 */
@PulumiTagMarker
public class V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgsBuilder internal constructor() {
    private var failureConditional:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalArgs>? =
        null

    private var failureNextStep:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureNextStepArgs>? =
        null

    private var failureResponse:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureResponseArgs>? =
        null

    private var successConditional:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditionalArgs>? =
        null

    private var successNextStep:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgs>? =
        null

    private var successResponse:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessResponseArgs>? =
        null

    private var timeoutConditional:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalArgs>? =
        null

    private var timeoutNextStep:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgs>? =
        null

    private var timeoutResponse:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutResponseArgs>? =
        null

    /**
     * @param value Configuration block for conditional branches to evaluate after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed. See `failure_conditional`.
     */
    @JvmName("grcphtmxqccparwg")
    public suspend fun failureConditional(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalArgs>) {
        this.failureConditional = value
    }

    /**
     * @param value Configuration block for the next step the bot runs after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed. See `failure_next_step`.
     */
    @JvmName("lumiepdocsfhsfob")
    public suspend fun failureNextStep(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureNextStepArgs>) {
        this.failureNextStep = value
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
     */
    @JvmName("euvxrwoecqxdwbvo")
    public suspend fun failureResponse(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureResponseArgs>) {
        this.failureResponse = value
    }

    /**
     * @param value Configuration block for conditional branches to evaluate after the dialog code hook finishes successfully. See `success_conditional`.
     */
    @JvmName("obiehqpityrqxurn")
    public suspend fun successConditional(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditionalArgs>) {
        this.successConditional = value
    }

    /**
     * @param value Configuration block for the next step the bot runs after the dialog code hook finishes successfully. See `success_next_step`.
     */
    @JvmName("fhkrfybhwwvmyrle")
    public suspend fun successNextStep(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgs>) {
        this.successNextStep = value
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `success_response`.
     */
    @JvmName("nvbqhpbgpwglolqd")
    public suspend fun successResponse(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessResponseArgs>) {
        this.successResponse = value
    }

    /**
     * @param value Configuration block for conditional branches to evaluate if the code hook times out. See `timeout_conditional`.
     */
    @JvmName("lxhsprfdbvwsbppv")
    public suspend fun timeoutConditional(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalArgs>) {
        this.timeoutConditional = value
    }

    /**
     * @param value Configuration block for the next step that the bot runs when the code hook times out. See `timeout_next_step`.
     */
    @JvmName("bukaqehvhmltxsgd")
    public suspend fun timeoutNextStep(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgs>) {
        this.timeoutNextStep = value
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond the user input. See `timeout_response`.
     */
    @JvmName("gxlugjvjwdhymydm")
    public suspend fun timeoutResponse(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutResponseArgs>) {
        this.timeoutResponse = value
    }

    /**
     * @param value Configuration block for conditional branches to evaluate after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed. See `failure_conditional`.
     */
    @JvmName("jaynypxfpwspdpwb")
    public suspend fun failureConditional(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureConditional = mapped
    }

    /**
     * @param argument Configuration block for conditional branches to evaluate after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed. See `failure_conditional`.
     */
    @JvmName("cgrfwuqgomqbqbsk")
    public suspend fun failureConditional(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.failureConditional = mapped
    }

    /**
     * @param value Configuration block for the next step the bot runs after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed. See `failure_next_step`.
     */
    @JvmName("hsygssmnltprbxnh")
    public suspend fun failureNextStep(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureNextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step the bot runs after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed. See `failure_next_step`.
     */
    @JvmName("pcqkwnywqlrogglt")
    public suspend fun failureNextStep(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.failureNextStep = mapped
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
     */
    @JvmName("gjxyjcjyagnpditt")
    public suspend fun failureResponse(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureResponse = mapped
    }

    /**
     * @param argument Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
     */
    @JvmName("jrsdxkqempxquyvg")
    public suspend fun failureResponse(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.failureResponse = mapped
    }

    /**
     * @param value Configuration block for conditional branches to evaluate after the dialog code hook finishes successfully. See `success_conditional`.
     */
    @JvmName("kqcvpdglfbalujje")
    public suspend fun successConditional(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successConditional = mapped
    }

    /**
     * @param argument Configuration block for conditional branches to evaluate after the dialog code hook finishes successfully. See `success_conditional`.
     */
    @JvmName("tdbbcxwdvucwvcjv")
    public suspend fun successConditional(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditionalArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditionalArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.successConditional = mapped
    }

    /**
     * @param value Configuration block for the next step the bot runs after the dialog code hook finishes successfully. See `success_next_step`.
     */
    @JvmName("wnhjqcvelwiwuqem")
    public suspend fun successNextStep(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successNextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step the bot runs after the dialog code hook finishes successfully. See `success_next_step`.
     */
    @JvmName("wqnvwnxlqhwndlto")
    public suspend fun successNextStep(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.successNextStep = mapped
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `success_response`.
     */
    @JvmName("iadwqjcvawoiryci")
    public suspend fun successResponse(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successResponse = mapped
    }

    /**
     * @param argument Configuration block for message groups that Amazon Lex uses to respond the user input. See `success_response`.
     */
    @JvmName("rvwkpnhsxnfwwohu")
    public suspend fun successResponse(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.successResponse = mapped
    }

    /**
     * @param value Configuration block for conditional branches to evaluate if the code hook times out. See `timeout_conditional`.
     */
    @JvmName("puvndurcowkarupw")
    public suspend fun timeoutConditional(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutConditional = mapped
    }

    /**
     * @param argument Configuration block for conditional branches to evaluate if the code hook times out. See `timeout_conditional`.
     */
    @JvmName("blsqptqrjwfcjtxn")
    public suspend fun timeoutConditional(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeoutConditional = mapped
    }

    /**
     * @param value Configuration block for the next step that the bot runs when the code hook times out. See `timeout_next_step`.
     */
    @JvmName("pbxpimakjmwrqxel")
    public suspend fun timeoutNextStep(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutNextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step that the bot runs when the code hook times out. See `timeout_next_step`.
     */
    @JvmName("lyfufsruoefigshb")
    public suspend fun timeoutNextStep(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeoutNextStep = mapped
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond the user input. See `timeout_response`.
     */
    @JvmName("bdtcyrmexqedyhor")
    public suspend fun timeoutResponse(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutResponse = mapped
    }

    /**
     * @param argument Configuration block for a list of message groups that Amazon Lex uses to respond the user input. See `timeout_response`.
     */
    @JvmName("ugdtphnsligndgtc")
    public suspend fun timeoutResponse(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeoutResponse = mapped
    }

    internal fun build(): V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgs =
        V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationArgs(
            failureConditional = failureConditional,
            failureNextStep = failureNextStep,
            failureResponse = failureResponse,
            successConditional = successConditional,
            successNextStep = successNextStep,
            successResponse = successResponse,
            timeoutConditional = timeoutConditional,
            timeoutNextStep = timeoutNextStep,
            timeoutResponse = timeoutResponse,
        )
}
