@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchNextStepDialogActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property slotToElicit If the dialog action is `ElicitSlot`, defines the slot to elicit from the user.
 * @property suppressNextMessage Whether the next message for the intent is _not_ used.
 * @property type Action that the bot should execute. Valid values are `ElicitIntent`, `StartIntent`, `ElicitSlot`, `EvaluateConditional`, `InvokeDialogCodeHook`, `ConfirmIntent`, `FulfillIntent`, `CloseIntent`, `EndConversation`.
 */
public data class
V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchNextStepDialogActionArgs(
    public val slotToElicit: Output<String>? = null,
    public val suppressNextMessage: Output<Boolean>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchNextStepDialogActionArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchNextStepDialogActionArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchNextStepDialogActionArgs.builder()
            .slotToElicit(slotToElicit?.applyValue({ args0 -> args0 }))
            .suppressNextMessage(suppressNextMessage?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchNextStepDialogActionArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchNextStepDialogActionArgsBuilder
internal constructor() {
    private var slotToElicit: Output<String>? = null

    private var suppressNextMessage: Output<Boolean>? = null

    private var type: Output<String>? = null

    /**
     * @param value If the dialog action is `ElicitSlot`, defines the slot to elicit from the user.
     */
    @JvmName("uirqnmshxtcqhjju")
    public suspend fun slotToElicit(`value`: Output<String>) {
        this.slotToElicit = value
    }

    /**
     * @param value Whether the next message for the intent is _not_ used.
     */
    @JvmName("fociroxcgfolixxr")
    public suspend fun suppressNextMessage(`value`: Output<Boolean>) {
        this.suppressNextMessage = value
    }

    /**
     * @param value Action that the bot should execute. Valid values are `ElicitIntent`, `StartIntent`, `ElicitSlot`, `EvaluateConditional`, `InvokeDialogCodeHook`, `ConfirmIntent`, `FulfillIntent`, `CloseIntent`, `EndConversation`.
     */
    @JvmName("dlbmvvxxsrpwprmq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value If the dialog action is `ElicitSlot`, defines the slot to elicit from the user.
     */
    @JvmName("uajdrabvwxqpgeav")
    public suspend fun slotToElicit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slotToElicit = mapped
    }

    /**
     * @param value Whether the next message for the intent is _not_ used.
     */
    @JvmName("qiwqlcufuhdhvijd")
    public suspend fun suppressNextMessage(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressNextMessage = mapped
    }

    /**
     * @param value Action that the bot should execute. Valid values are `ElicitIntent`, `StartIntent`, `ElicitSlot`, `EvaluateConditional`, `InvokeDialogCodeHook`, `ConfirmIntent`, `FulfillIntent`, `CloseIntent`, `EndConversation`.
     */
    @JvmName("fttjtcokxmxyxkwo")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchNextStepDialogActionArgs =
        V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchNextStepDialogActionArgs(
            slotToElicit = slotToElicit,
            suppressNextMessage = suppressNextMessage,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
