@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property buttons Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
 * @property imageUrl URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
 * @property subtitle Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
 * @property title Title to display on the response card. The format of the title is determined by the platform displaying the response card.
 */
public data class
V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs(
    public val buttons: Output<List<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardButtonArgs>>? =
        null,
    public val imageUrl: Output<String>? = null,
    public val subtitle: Output<String>? = null,
    public val title: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs.builder()
            .buttons(
                buttons?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .imageUrl(imageUrl?.applyValue({ args0 -> args0 }))
            .subtitle(subtitle?.applyValue({ args0 -> args0 }))
            .title(title.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgsBuilder
internal constructor() {
    private var buttons:
        Output<List<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardButtonArgs>>? =
        null

    private var imageUrl: Output<String>? = null

    private var subtitle: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("geqhyefvkfacqtnq")
    public suspend fun buttons(`value`: Output<List<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardButtonArgs>>) {
        this.buttons = value
    }

    @JvmName("cquyxvbfbeqqqrbc")
    public suspend fun buttons(vararg values: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardButtonArgs>) {
        this.buttons = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("rkokpkuuvddhddwb")
    public suspend fun buttons(values: List<Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardButtonArgs>>) {
        this.buttons = Output.all(values)
    }

    /**
     * @param value URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
     */
    @JvmName("ikfogqcuchohxcha")
    public suspend fun imageUrl(`value`: Output<String>) {
        this.imageUrl = value
    }

    /**
     * @param value Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
     */
    @JvmName("gcocrgknpseejnmf")
    public suspend fun subtitle(`value`: Output<String>) {
        this.subtitle = value
    }

    /**
     * @param value Title to display on the response card. The format of the title is determined by the platform displaying the response card.
     */
    @JvmName("rnqohjediglsogqq")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("ikyqfprxwrqqygox")
    public suspend fun buttons(`value`: List<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardButtonArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("mefdpaipsydnrdrn")
    public suspend fun buttons(argument: List<suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardButtonArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardButtonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("qyyqyqpsaobcxhhc")
    public suspend fun buttons(vararg argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardButtonArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardButtonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("yjvbtcwklmowbhru")
    public suspend fun buttons(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardButtonArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardButtonArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param values Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("lxsqpifwaodpwfxb")
    public suspend fun buttons(vararg values: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardButtonArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.buttons = mapped
    }

    /**
     * @param value URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
     */
    @JvmName("dbfvvlwjtgvpvkws")
    public suspend fun imageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageUrl = mapped
    }

    /**
     * @param value Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
     */
    @JvmName("uhpquibvpefqqxuw")
    public suspend fun subtitle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subtitle = mapped
    }

    /**
     * @param value Title to display on the response card. The format of the title is determined by the platform displaying the response card.
     */
    @JvmName("ryrmdnraxcdnadkn")
    public suspend fun title(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs =
        V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs(
            buttons = buttons,
            imageUrl = imageUrl,
            subtitle = subtitle,
            title = title ?: throw PulumiNullFieldException("title"),
        )
}
