@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property dialogAction Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
 * @property intent Configuration block for override settings to configure the intent state. See `intent`.
 * @property sessionAttributes Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
 */
public data class
V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgs(
    public val dialogAction: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepDialogActionArgs>? =
        null,
    public val intent: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepIntentArgs>? =
        null,
    public val sessionAttributes: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgs.builder()
            .dialogAction(dialogAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .intent(intent?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sessionAttributes(
                sessionAttributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgsBuilder
internal constructor() {
    private var dialogAction:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepDialogActionArgs>? =
        null

    private var intent:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepIntentArgs>? =
        null

    private var sessionAttributes: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
     */
    @JvmName("vlchnhrsoxjmlpan")
    public suspend fun dialogAction(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepDialogActionArgs>) {
        this.dialogAction = value
    }

    /**
     * @param value Configuration block for override settings to configure the intent state. See `intent`.
     */
    @JvmName("mebrepoqgiessyhr")
    public suspend fun intent(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepIntentArgs>) {
        this.intent = value
    }

    /**
     * @param value Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
     */
    @JvmName("yhqtorfuymkggpvf")
    public suspend fun sessionAttributes(`value`: Output<Map<String, String>>) {
        this.sessionAttributes = value
    }

    /**
     * @param value Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
     */
    @JvmName("vkipqhgoxqrimlrq")
    public suspend fun dialogAction(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepDialogActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dialogAction = mapped
    }

    /**
     * @param argument Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
     */
    @JvmName("mtdnisjwypvpatxx")
    public suspend fun dialogAction(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepDialogActionArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepDialogActionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dialogAction = mapped
    }

    /**
     * @param value Configuration block for override settings to configure the intent state. See `intent`.
     */
    @JvmName("erklgnrmlsduepey")
    public suspend fun intent(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepIntentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intent = mapped
    }

    /**
     * @param argument Configuration block for override settings to configure the intent state. See `intent`.
     */
    @JvmName("jylhhaivqiffpfpp")
    public suspend fun intent(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepIntentArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepIntentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.intent = mapped
    }

    /**
     * @param value Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
     */
    @JvmName("xstetvwhwtevhejl")
    public suspend fun sessionAttributes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionAttributes = mapped
    }

    /**
     * @param values Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
     */
    @JvmName("qgsjrjpuqkhfehxs")
    public fun sessionAttributes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionAttributes = mapped
    }

    internal fun build(): V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgs =
        V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepArgs(
            dialogAction = dialogAction,
            intent = intent,
            sessionAttributes = sessionAttributes,
        )
}
