@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customPayload Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
 * @property imageResponseCard Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
 * @property plainTextMessage Configuration block for a message in plain text format. See `plain_text_message`.
 * @property ssmlMessage Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
 */
public data class
V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageArgs(
    public val customPayload: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgs>? =
        null,
    public val imageResponseCard: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs>? =
        null,
    public val plainTextMessage: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgs>? =
        null,
    public val ssmlMessage: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageArgs.builder()
            .customPayload(customPayload?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageResponseCard(imageResponseCard?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .plainTextMessage(plainTextMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ssmlMessage(ssmlMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageArgsBuilder
internal constructor() {
    private var customPayload:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgs>? =
        null

    private var imageResponseCard:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs>? =
        null

    private var plainTextMessage:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgs>? =
        null

    private var ssmlMessage:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgs>? =
        null

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("rvnigenuccmgemao")
    public suspend fun customPayload(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgs>) {
        this.customPayload = value
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("qqexwjihbuajvkqp")
    public suspend fun imageResponseCard(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs>) {
        this.imageResponseCard = value
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("gjafrqycfyvddgga")
    public suspend fun plainTextMessage(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgs>) {
        this.plainTextMessage = value
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("uiiwgorynwvenbwn")
    public suspend fun ssmlMessage(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgs>) {
        this.ssmlMessage = value
    }

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("saqtnhljplfkhxao")
    public suspend fun customPayload(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPayload = mapped
    }

    /**
     * @param argument Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("iebghsqvlsbkabur")
    public suspend fun customPayload(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customPayload = mapped
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("pulagetxoiollpgo")
    public suspend fun imageResponseCard(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageResponseCard = mapped
    }

    /**
     * @param argument Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("hjrejsicghcytlks")
    public suspend fun imageResponseCard(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.imageResponseCard = mapped
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("xlkaamonuyyvidix")
    public suspend fun plainTextMessage(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plainTextMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("tpkpwjhxyqalksbi")
    public suspend fun plainTextMessage(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.plainTextMessage = mapped
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("sjmlledrwficsyax")
    public suspend fun ssmlMessage(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssmlMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("hpvmbtihudncxefn")
    public suspend fun ssmlMessage(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ssmlMessage = mapped
    }

    internal fun build(): V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageArgs =
        V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutConditionalConditionalBranchResponseMessageGroupMessageArgs(
            customPayload = customPayload,
            imageResponseCard = imageResponseCard,
            plainTextMessage = plainTextMessage,
            ssmlMessage = ssmlMessage,
        )
}
