@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property dialogAction Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
 * @property intent Configuration block for override settings to configure the intent state. See `intent`.
 * @property sessionAttributes Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
 */
public data class
V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgs(
    public val dialogAction: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepDialogActionArgs>? =
        null,
    public val intent: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepIntentArgs>? =
        null,
    public val sessionAttributes: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgs.builder()
            .dialogAction(dialogAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .intent(intent?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sessionAttributes(
                sessionAttributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgsBuilder
internal constructor() {
    private var dialogAction:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepDialogActionArgs>? =
        null

    private var intent:
        Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepIntentArgs>? =
        null

    private var sessionAttributes: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
     */
    @JvmName("ijxkqkaltdaaaoig")
    public suspend fun dialogAction(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepDialogActionArgs>) {
        this.dialogAction = value
    }

    /**
     * @param value Configuration block for override settings to configure the intent state. See `intent`.
     */
    @JvmName("avfekhpwaylodjxp")
    public suspend fun intent(`value`: Output<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepIntentArgs>) {
        this.intent = value
    }

    /**
     * @param value Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
     */
    @JvmName("jkuxrdpgwdaaiabb")
    public suspend fun sessionAttributes(`value`: Output<Map<String, String>>) {
        this.sessionAttributes = value
    }

    /**
     * @param value Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
     */
    @JvmName("emmgyaiifedosvxa")
    public suspend fun dialogAction(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepDialogActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dialogAction = mapped
    }

    /**
     * @param argument Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
     */
    @JvmName("pmbftmkjjnbvfrbf")
    public suspend fun dialogAction(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepDialogActionArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepDialogActionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dialogAction = mapped
    }

    /**
     * @param value Configuration block for override settings to configure the intent state. See `intent`.
     */
    @JvmName("ejaafhxqyjldaevv")
    public suspend fun intent(`value`: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepIntentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intent = mapped
    }

    /**
     * @param argument Configuration block for override settings to configure the intent state. See `intent`.
     */
    @JvmName("mcvwlxbyyrrfwqty")
    public suspend fun intent(argument: suspend V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepIntentArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepIntentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.intent = mapped
    }

    /**
     * @param value Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
     */
    @JvmName("duyixnohdiyenefl")
    public suspend fun sessionAttributes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionAttributes = mapped
    }

    /**
     * @param values Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
     */
    @JvmName("yrejpvotijvxylvj")
    public fun sessionAttributes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionAttributes = mapped
    }

    internal fun build(): V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgs =
        V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationTimeoutNextStepArgs(
            dialogAction = dialogAction,
            intent = intent,
            sessionAttributes = sessionAttributes,
        )
}
