@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property codeHook Configuration block for the dialog code hook that is called by Amazon Lex at a step of the conversation. See `code_hook`.
 * @property conditional Configuration block for conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition. See `conditional`.
 * @property initialResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `initial_response`.
 * @property nextStep Configuration block for the next step in the conversation. See `next_step`.
 */
public data class V2modelsIntentInitialResponseSettingArgs(
    public val codeHook: Output<V2modelsIntentInitialResponseSettingCodeHookArgs>? = null,
    public val conditional: Output<V2modelsIntentInitialResponseSettingConditionalArgs>? = null,
    public val initialResponse: Output<V2modelsIntentInitialResponseSettingInitialResponseArgs>? =
        null,
    public val nextStep: Output<V2modelsIntentInitialResponseSettingNextStepArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingArgs.builder()
            .codeHook(codeHook?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .conditional(conditional?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .initialResponse(initialResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nextStep(nextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingArgs].
 */
@PulumiTagMarker
public class V2modelsIntentInitialResponseSettingArgsBuilder internal constructor() {
    private var codeHook: Output<V2modelsIntentInitialResponseSettingCodeHookArgs>? = null

    private var conditional: Output<V2modelsIntentInitialResponseSettingConditionalArgs>? = null

    private var initialResponse: Output<V2modelsIntentInitialResponseSettingInitialResponseArgs>? =
        null

    private var nextStep: Output<V2modelsIntentInitialResponseSettingNextStepArgs>? = null

    /**
     * @param value Configuration block for the dialog code hook that is called by Amazon Lex at a step of the conversation. See `code_hook`.
     */
    @JvmName("xnoahcomygmwybmp")
    public suspend fun codeHook(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookArgs>) {
        this.codeHook = value
    }

    /**
     * @param value Configuration block for conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition. See `conditional`.
     */
    @JvmName("gstdenenrvjvwten")
    public suspend fun conditional(`value`: Output<V2modelsIntentInitialResponseSettingConditionalArgs>) {
        this.conditional = value
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `initial_response`.
     */
    @JvmName("acrbksfchdeiauvh")
    public suspend fun initialResponse(`value`: Output<V2modelsIntentInitialResponseSettingInitialResponseArgs>) {
        this.initialResponse = value
    }

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("atftpxvjfdbtcphq")
    public suspend fun nextStep(`value`: Output<V2modelsIntentInitialResponseSettingNextStepArgs>) {
        this.nextStep = value
    }

    /**
     * @param value Configuration block for the dialog code hook that is called by Amazon Lex at a step of the conversation. See `code_hook`.
     */
    @JvmName("eqjwjbfpmyfplnod")
    public suspend fun codeHook(`value`: V2modelsIntentInitialResponseSettingCodeHookArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeHook = mapped
    }

    /**
     * @param argument Configuration block for the dialog code hook that is called by Amazon Lex at a step of the conversation. See `code_hook`.
     */
    @JvmName("ntsfwjuioctiitwo")
    public suspend fun codeHook(argument: suspend V2modelsIntentInitialResponseSettingCodeHookArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentInitialResponseSettingCodeHookArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.codeHook = mapped
    }

    /**
     * @param value Configuration block for conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition. See `conditional`.
     */
    @JvmName("osfsckdkjsnsunei")
    public suspend fun conditional(`value`: V2modelsIntentInitialResponseSettingConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditional = mapped
    }

    /**
     * @param argument Configuration block for conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition. See `conditional`.
     */
    @JvmName("eyxoeyiyacidyhmv")
    public suspend fun conditional(argument: suspend V2modelsIntentInitialResponseSettingConditionalArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentInitialResponseSettingConditionalArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.conditional = mapped
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `initial_response`.
     */
    @JvmName("warghwxmubanmgax")
    public suspend fun initialResponse(`value`: V2modelsIntentInitialResponseSettingInitialResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialResponse = mapped
    }

    /**
     * @param argument Configuration block for message groups that Amazon Lex uses to respond the user input. See `initial_response`.
     */
    @JvmName("tblbsvflxavjdsou")
    public suspend fun initialResponse(argument: suspend V2modelsIntentInitialResponseSettingInitialResponseArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentInitialResponseSettingInitialResponseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.initialResponse = mapped
    }

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("pqpgbeuvaegisibw")
    public suspend fun nextStep(`value`: V2modelsIntentInitialResponseSettingNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("gmnxsgmybstbgcsl")
    public suspend fun nextStep(argument: suspend V2modelsIntentInitialResponseSettingNextStepArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentInitialResponseSettingNextStepArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.nextStep = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingArgs =
        V2modelsIntentInitialResponseSettingArgs(
            codeHook = codeHook,
            conditional = conditional,
            initialResponse = initialResponse,
            nextStep = nextStep,
        )
}
