@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property active Whether a dialog code hook is used when the intent is activated.
 * @property enableCodeHookInvocation Whether a Lambda function should be invoked for the dialog.
 * @property invocationLabel Label that indicates the dialog step from which the dialog code hook is happening.
 * @property postCodeHookSpecification Configuration block that contains the responses and actions that Amazon Lex takes after the Lambda function is complete. See `post_code_hook_specification`.
 */
public data class V2modelsIntentInitialResponseSettingCodeHookArgs(
    public val active: Output<Boolean>,
    public val enableCodeHookInvocation: Output<Boolean>,
    public val invocationLabel: Output<String>? = null,
    public val postCodeHookSpecification: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgs>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookArgs = com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookArgs.builder()
        .active(active.applyValue({ args0 -> args0 }))
        .enableCodeHookInvocation(enableCodeHookInvocation.applyValue({ args0 -> args0 }))
        .invocationLabel(invocationLabel?.applyValue({ args0 -> args0 }))
        .postCodeHookSpecification(
            postCodeHookSpecification.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        ).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingCodeHookArgs].
 */
@PulumiTagMarker
public class V2modelsIntentInitialResponseSettingCodeHookArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var enableCodeHookInvocation: Output<Boolean>? = null

    private var invocationLabel: Output<String>? = null

    private var postCodeHookSpecification:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgs>? = null

    /**
     * @param value Whether a dialog code hook is used when the intent is activated.
     */
    @JvmName("gxjlflerqumvxvel")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Whether a Lambda function should be invoked for the dialog.
     */
    @JvmName("eajxernxjxtdipqw")
    public suspend fun enableCodeHookInvocation(`value`: Output<Boolean>) {
        this.enableCodeHookInvocation = value
    }

    /**
     * @param value Label that indicates the dialog step from which the dialog code hook is happening.
     */
    @JvmName("btarjlafgfkdhugj")
    public suspend fun invocationLabel(`value`: Output<String>) {
        this.invocationLabel = value
    }

    /**
     * @param value Configuration block that contains the responses and actions that Amazon Lex takes after the Lambda function is complete. See `post_code_hook_specification`.
     */
    @JvmName("cxxrnfxwneyiocdd")
    public suspend fun postCodeHookSpecification(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgs>) {
        this.postCodeHookSpecification = value
    }

    /**
     * @param value Whether a dialog code hook is used when the intent is activated.
     */
    @JvmName("vnocgjmyrlqdlefa")
    public suspend fun active(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Whether a Lambda function should be invoked for the dialog.
     */
    @JvmName("nklgrtdargicywam")
    public suspend fun enableCodeHookInvocation(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableCodeHookInvocation = mapped
    }

    /**
     * @param value Label that indicates the dialog step from which the dialog code hook is happening.
     */
    @JvmName("dvcdxhwabtlyjcgj")
    public suspend fun invocationLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invocationLabel = mapped
    }

    /**
     * @param value Configuration block that contains the responses and actions that Amazon Lex takes after the Lambda function is complete. See `post_code_hook_specification`.
     */
    @JvmName("ccbkfkyeqrjkunrf")
    public suspend fun postCodeHookSpecification(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.postCodeHookSpecification = mapped
    }

    /**
     * @param argument Configuration block that contains the responses and actions that Amazon Lex takes after the Lambda function is complete. See `post_code_hook_specification`.
     */
    @JvmName("rlqanxndbcioiwpt")
    public suspend fun postCodeHookSpecification(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.postCodeHookSpecification = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingCodeHookArgs =
        V2modelsIntentInitialResponseSettingCodeHookArgs(
            active = active ?: throw PulumiNullFieldException("active"),
            enableCodeHookInvocation = enableCodeHookInvocation ?: throw
                PulumiNullFieldException("enableCodeHookInvocation"),
            invocationLabel = invocationLabel,
            postCodeHookSpecification = postCodeHookSpecification ?: throw
                PulumiNullFieldException("postCodeHookSpecification"),
        )
}
