@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property failureConditional Configuration block for conditional branches to evaluate after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed.
 * @property failureNextStep Configuration block for the next step the bot runs after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed . See `failure_next_step`.
 * @property failureResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
 * @property successConditional Configuration block for conditional branches to evaluate after the dialog code hook finishes successfully. See `success_conditional`.
 * @property successNextStep Configuration block for the next step the bot runs after the dialog code hook finishes successfully. See `success_next_step`.
 * @property successResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `success_response`.
 * @property timeoutConditional Configuration block for conditional branches to evaluate if the code hook times out. See `timeout_conditional`.
 * @property timeoutNextStep Configuration block for the next step that the bot runs when the code hook times out. See `timeout_next_step`.
 * @property timeoutResponse Configuration block for a list of message groups that Amazon Lex uses to respond the user input. See `timeout_response`.
 */
public data class V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgs(
    public val failureConditional: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalArgs>? =
        null,
    public val failureNextStep: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureNextStepArgs>? =
        null,
    public val failureResponse: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureResponseArgs>? =
        null,
    public val successConditional: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalArgs>? =
        null,
    public val successNextStep: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessNextStepArgs>? =
        null,
    public val successResponse: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseArgs>? =
        null,
    public val timeoutConditional: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalArgs>? =
        null,
    public val timeoutNextStep: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutNextStepArgs>? =
        null,
    public val timeoutResponse: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgs.builder()
            .failureConditional(
                failureConditional?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .failureNextStep(failureNextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .failureResponse(failureResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .successConditional(
                successConditional?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .successNextStep(successNextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .successResponse(successResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeoutConditional(
                timeoutConditional?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .timeoutNextStep(timeoutNextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeoutResponse(
                timeoutResponse?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgs].
 */
@PulumiTagMarker
public class V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgsBuilder
internal constructor() {
    private var failureConditional:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalArgs>? =
        null

    private var failureNextStep:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureNextStepArgs>? =
        null

    private var failureResponse:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureResponseArgs>? =
        null

    private var successConditional:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalArgs>? =
        null

    private var successNextStep:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessNextStepArgs>? =
        null

    private var successResponse:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseArgs>? =
        null

    private var timeoutConditional:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalArgs>? =
        null

    private var timeoutNextStep:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutNextStepArgs>? =
        null

    private var timeoutResponse:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseArgs>? =
        null

    /**
     * @param value Configuration block for conditional branches to evaluate after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed.
     */
    @JvmName("ubixmcgijbqeuqjp")
    public suspend fun failureConditional(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalArgs>) {
        this.failureConditional = value
    }

    /**
     * @param value Configuration block for the next step the bot runs after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed . See `failure_next_step`.
     */
    @JvmName("hcspfxhxbrxswgfy")
    public suspend fun failureNextStep(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureNextStepArgs>) {
        this.failureNextStep = value
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
     */
    @JvmName("brnqrpmrotyxllhg")
    public suspend fun failureResponse(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureResponseArgs>) {
        this.failureResponse = value
    }

    /**
     * @param value Configuration block for conditional branches to evaluate after the dialog code hook finishes successfully. See `success_conditional`.
     */
    @JvmName("pajcxapqecdgthpt")
    public suspend fun successConditional(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalArgs>) {
        this.successConditional = value
    }

    /**
     * @param value Configuration block for the next step the bot runs after the dialog code hook finishes successfully. See `success_next_step`.
     */
    @JvmName("xrshtbmviovwskbw")
    public suspend fun successNextStep(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessNextStepArgs>) {
        this.successNextStep = value
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `success_response`.
     */
    @JvmName("ybjdcrkbpjmyawxs")
    public suspend fun successResponse(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseArgs>) {
        this.successResponse = value
    }

    /**
     * @param value Configuration block for conditional branches to evaluate if the code hook times out. See `timeout_conditional`.
     */
    @JvmName("sggvdoixhjsluygb")
    public suspend fun timeoutConditional(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalArgs>) {
        this.timeoutConditional = value
    }

    /**
     * @param value Configuration block for the next step that the bot runs when the code hook times out. See `timeout_next_step`.
     */
    @JvmName("fihxjmpkbdyvagiy")
    public suspend fun timeoutNextStep(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutNextStepArgs>) {
        this.timeoutNextStep = value
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond the user input. See `timeout_response`.
     */
    @JvmName("aofocvagrpuckrdy")
    public suspend fun timeoutResponse(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseArgs>) {
        this.timeoutResponse = value
    }

    /**
     * @param value Configuration block for conditional branches to evaluate after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed.
     */
    @JvmName("xtfqwaprmvgluhbm")
    public suspend fun failureConditional(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureConditional = mapped
    }

    /**
     * @param argument Configuration block for conditional branches to evaluate after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed.
     */
    @JvmName("jurlfcdgqpdprcrg")
    public suspend fun failureConditional(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.failureConditional = mapped
    }

    /**
     * @param value Configuration block for the next step the bot runs after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed . See `failure_next_step`.
     */
    @JvmName("vsjkcclelsyobcba")
    public suspend fun failureNextStep(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureNextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step the bot runs after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed . See `failure_next_step`.
     */
    @JvmName("ewbfjwhyeokfyhhn")
    public suspend fun failureNextStep(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.failureNextStep = mapped
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
     */
    @JvmName("dnggqyjrxyuxcglm")
    public suspend fun failureResponse(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureResponse = mapped
    }

    /**
     * @param argument Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
     */
    @JvmName("clnsedwyxuweinko")
    public suspend fun failureResponse(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.failureResponse = mapped
    }

    /**
     * @param value Configuration block for conditional branches to evaluate after the dialog code hook finishes successfully. See `success_conditional`.
     */
    @JvmName("exfacdjnsggqoglb")
    public suspend fun successConditional(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successConditional = mapped
    }

    /**
     * @param argument Configuration block for conditional branches to evaluate after the dialog code hook finishes successfully. See `success_conditional`.
     */
    @JvmName("rcmrkrjfqrgainwt")
    public suspend fun successConditional(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.successConditional = mapped
    }

    /**
     * @param value Configuration block for the next step the bot runs after the dialog code hook finishes successfully. See `success_next_step`.
     */
    @JvmName("bwviodxuphlgxwuo")
    public suspend fun successNextStep(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successNextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step the bot runs after the dialog code hook finishes successfully. See `success_next_step`.
     */
    @JvmName("dmppklrfdjeouxls")
    public suspend fun successNextStep(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.successNextStep = mapped
    }

    /**
     * @param value Configuration block for message groups that Amazon Lex uses to respond the user input. See `success_response`.
     */
    @JvmName("wxuxodsskhtoryei")
    public suspend fun successResponse(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successResponse = mapped
    }

    /**
     * @param argument Configuration block for message groups that Amazon Lex uses to respond the user input. See `success_response`.
     */
    @JvmName("ofcihhhlhomilcmp")
    public suspend fun successResponse(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.successResponse = mapped
    }

    /**
     * @param value Configuration block for conditional branches to evaluate if the code hook times out. See `timeout_conditional`.
     */
    @JvmName("acwolqfxvuchrvoj")
    public suspend fun timeoutConditional(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutConditional = mapped
    }

    /**
     * @param argument Configuration block for conditional branches to evaluate if the code hook times out. See `timeout_conditional`.
     */
    @JvmName("jxlfoghtqyhavrop")
    public suspend fun timeoutConditional(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeoutConditional = mapped
    }

    /**
     * @param value Configuration block for the next step that the bot runs when the code hook times out. See `timeout_next_step`.
     */
    @JvmName("tqrfmhkyxvqvcifa")
    public suspend fun timeoutNextStep(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutNextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step that the bot runs when the code hook times out. See `timeout_next_step`.
     */
    @JvmName("sgvabbvveajjyxtq")
    public suspend fun timeoutNextStep(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeoutNextStep = mapped
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond the user input. See `timeout_response`.
     */
    @JvmName("wrvbqenoonhxnwha")
    public suspend fun timeoutResponse(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutResponse = mapped
    }

    /**
     * @param argument Configuration block for a list of message groups that Amazon Lex uses to respond the user input. See `timeout_response`.
     */
    @JvmName("iqgxpgjfrolddodc")
    public suspend fun timeoutResponse(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeoutResponse = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgs =
        V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationArgs(
            failureConditional = failureConditional,
            failureNextStep = failureNextStep,
            failureResponse = failureResponse,
            successConditional = successConditional,
            successNextStep = successNextStep,
            successResponse = successResponse,
            timeoutConditional = timeoutConditional,
            timeoutNextStep = timeoutNextStep,
            timeoutResponse = timeoutResponse,
        )
}
