@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property condition Configuration block for the expression to evaluate. If the condition is true, the branch's actions are taken. See `condition`.
 * @property name Name of the branch.
 * @property nextStep Configuration block for the next step in the conversation. See `next_step`.
 * @property response Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
 */
public data class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchArgs(
    public val condition: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchConditionArgs>,
    public val name: Output<String>,
    public val nextStep: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchNextStepArgs>,
    public val response: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchArgs.builder()
            .condition(condition.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .nextStep(nextStep.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .response(response?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchArgsBuilder
internal constructor() {
    private var condition:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchConditionArgs>? =
        null

    private var name: Output<String>? = null

    private var nextStep:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchNextStepArgs>? =
        null

    private var response:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseArgs>? =
        null

    /**
     * @param value Configuration block for the expression to evaluate. If the condition is true, the branch's actions are taken. See `condition`.
     */
    @JvmName("ycchecxlgnxfyvmt")
    public suspend fun condition(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchConditionArgs>) {
        this.condition = value
    }

    /**
     * @param value Name of the branch.
     */
    @JvmName("intqrfwmoociykyu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("gktydfdogrgtdpku")
    public suspend fun nextStep(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchNextStepArgs>) {
        this.nextStep = value
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("qaifhetgntunpkqb")
    public suspend fun response(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseArgs>) {
        this.response = value
    }

    /**
     * @param value Configuration block for the expression to evaluate. If the condition is true, the branch's actions are taken. See `condition`.
     */
    @JvmName("nskusiwhtosweygj")
    public suspend fun condition(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchConditionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param argument Configuration block for the expression to evaluate. If the condition is true, the branch's actions are taken. See `condition`.
     */
    @JvmName("fqqswkqxgexthbgh")
    public suspend fun condition(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchConditionArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchConditionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.condition = mapped
    }

    /**
     * @param value Name of the branch.
     */
    @JvmName("ojcfnwjhakxxyqmb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("oiaofbhlloscgudj")
    public suspend fun nextStep(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchNextStepArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("utaiwrpxfgciajqj")
    public suspend fun nextStep(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.nextStep = mapped
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("jihmijbfatxipjub")
    public suspend fun response(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.response = mapped
    }

    /**
     * @param argument Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("vvmpoufliudoraam")
    public suspend fun response(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.response = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchArgs =
        V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchArgs(
            condition = condition ?: throw PulumiNullFieldException("condition"),
            name = name ?: throw PulumiNullFieldException("name"),
            nextStep = nextStep ?: throw PulumiNullFieldException("nextStep"),
            response = response,
        )
}
