@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customPayload Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
 * @property imageResponseCard Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
 * @property plainTextMessage Configuration block for a message in plain text format. See `plain_text_message`.
 * @property ssmlMessage Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
 */
public data class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageArgs(
    public val customPayload: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgs>? =
        null,
    public val imageResponseCard: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs>? =
        null,
    public val plainTextMessage: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgs>? =
        null,
    public val ssmlMessage: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageArgs.builder()
            .customPayload(customPayload?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageResponseCard(imageResponseCard?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .plainTextMessage(plainTextMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ssmlMessage(ssmlMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageArgsBuilder
internal constructor() {
    private var customPayload:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgs>? =
        null

    private var imageResponseCard:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs>? =
        null

    private var plainTextMessage:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgs>? =
        null

    private var ssmlMessage:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgs>? =
        null

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("nscqgmrrfxckdhmn")
    public suspend fun customPayload(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgs>) {
        this.customPayload = value
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("krinfvjoptbqjnnm")
    public suspend fun imageResponseCard(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs>) {
        this.imageResponseCard = value
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("hdgpowipiajqrnxp")
    public suspend fun plainTextMessage(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgs>) {
        this.plainTextMessage = value
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("xjloebdyppwgesuk")
    public suspend fun ssmlMessage(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgs>) {
        this.ssmlMessage = value
    }

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("yjqqfwcywhmjtkne")
    public suspend fun customPayload(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPayload = mapped
    }

    /**
     * @param argument Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("nmjuvqhyeqksecsg")
    public suspend fun customPayload(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageCustomPayloadArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customPayload = mapped
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("xhniolqoqihtqavr")
    public suspend fun imageResponseCard(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageResponseCard = mapped
    }

    /**
     * @param argument Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("qwvnpyinvthaxnyh")
    public suspend fun imageResponseCard(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageImageResponseCardArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.imageResponseCard = mapped
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("qtefkvlpspnywawj")
    public suspend fun plainTextMessage(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plainTextMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("kekhohfklubgpgvs")
    public suspend fun plainTextMessage(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessagePlainTextMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.plainTextMessage = mapped
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("btypyfwgmtdwlscf")
    public suspend fun ssmlMessage(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssmlMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("jhatofwbgprlaexs")
    public suspend fun ssmlMessage(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageSsmlMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ssmlMessage = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageArgs =
        V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalConditionalBranchResponseMessageGroupMessageArgs(
            customPayload = customPayload,
            imageResponseCard = imageResponseCard,
            plainTextMessage = plainTextMessage,
            ssmlMessage = ssmlMessage,
        )
}
