@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property dialogAction Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
 * @property intent Configuration block for override settings to configure the intent state. See `intent`.
 * @property sessionAttributes Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
 */
public data class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepArgs(
    public val dialogAction: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepDialogActionArgs>? =
        null,
    public val intent: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepIntentArgs>? =
        null,
    public val sessionAttributes: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepArgs.builder()
            .dialogAction(dialogAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .intent(intent?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sessionAttributes(
                sessionAttributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepArgsBuilder
internal constructor() {
    private var dialogAction:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepDialogActionArgs>? =
        null

    private var intent:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepIntentArgs>? =
        null

    private var sessionAttributes: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
     */
    @JvmName("mxurtrxnbsksmcwe")
    public suspend fun dialogAction(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepDialogActionArgs>) {
        this.dialogAction = value
    }

    /**
     * @param value Configuration block for override settings to configure the intent state. See `intent`.
     */
    @JvmName("ipkntbrsewopisnj")
    public suspend fun intent(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepIntentArgs>) {
        this.intent = value
    }

    /**
     * @param value Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
     */
    @JvmName("pefgrpiahfqsmtyu")
    public suspend fun sessionAttributes(`value`: Output<Map<String, String>>) {
        this.sessionAttributes = value
    }

    /**
     * @param value Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
     */
    @JvmName("hqpprwedmnvwvtfb")
    public suspend fun dialogAction(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepDialogActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dialogAction = mapped
    }

    /**
     * @param argument Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
     */
    @JvmName("wnfcnmihgivcywwc")
    public suspend fun dialogAction(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepDialogActionArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepDialogActionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dialogAction = mapped
    }

    /**
     * @param value Configuration block for override settings to configure the intent state. See `intent`.
     */
    @JvmName("fuvqjrcnwnjgfwys")
    public suspend fun intent(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepIntentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intent = mapped
    }

    /**
     * @param argument Configuration block for override settings to configure the intent state. See `intent`.
     */
    @JvmName("waayvwlbvukgtihj")
    public suspend fun intent(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepIntentArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepIntentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.intent = mapped
    }

    /**
     * @param value Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
     */
    @JvmName("bvmqmsardltnmpbi")
    public suspend fun sessionAttributes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionAttributes = mapped
    }

    /**
     * @param values Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
     */
    @JvmName("slsoiwywyvbwxrui")
    public fun sessionAttributes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionAttributes = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepArgs =
        V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditionalDefaultBranchNextStepArgs(
            dialogAction = dialogAction,
            intent = intent,
            sessionAttributes = sessionAttributes,
        )
}
